/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"

void
sg_data_edit_dialog(SGdataset *dataset)
{
  GtkWidget *sw;
  SGworksheet *sheet = NULL;
  SGdialog *dialog;
  SGdialogButton rvalue;
  GtkPlotArray *array = NULL;
  GList *list = NULL;
  gint nrows, ncols;
  GtkPlotArray *used_arrays[30]; 
  gint i = 0;

  dialog = SG_DIALOG(sg_dialog_new( _( "Edit data" ), GTK_ORIENTATION_VERTICAL,
SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_END));

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_set_border_width(GTK_CONTAINER(sw), 5);
  gtk_widget_set_usize(sw, 200, 200);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(dialog->box),sw,TRUE,TRUE,0);

  list = dataset->arrays->arrays;
  nrows = ncols = 0;
  while(list){
    array = GTK_PLOT_ARRAY(list->data);
/*
    if(array->required || array->size > 0) ncols++;
*/
    if(array->required) nrows = array->size;
    list = list->next;
    ncols++;
  }

  sheet = sg_worksheet_new( _("Edit data"), nrows, ncols);
  gtk_container_add(GTK_CONTAINER(sw), GTK_WIDGET(sheet));
  gtk_widget_ref(GTK_WIDGET(sheet));

  list = dataset->arrays->arrays;
  while(list){
    gchar text[200];

    array = GTK_PLOT_ARRAY(list->data);

/*
    if(array->required || array->size > 0) 
*/
    {
      used_arrays[i] = array;
      g_snprintf(text, 200, "%s (%s)", array->label, array->name); 
      sg_worksheet_set_column_data(sheet, i, array);
      sg_worksheet_set_column_name(sheet, i, text); 
      i++;
    }

    list = list->next;
  }
  
  gtk_widget_show_all(dialog->box);

  rvalue = sg_dialog_run(GTK_WIDGET(dialog), GTK_OBJECT(sheet));

  if(rvalue == SG_BUTTON_CANCEL) {
    if(GTK_IS_WIDGET(sheet)) gtk_widget_destroy(GTK_WIDGET(sheet));
    return;
  }

  for(i = 0; i < ncols; i++){
    GtkType type;

    type = used_arrays[i]->type; 

    array = sg_worksheet_get_column_data(sheet, i, type); 
    if(array){
      if(type == GTK_TYPE_DOUBLE){
        gtk_plot_array_set(used_arrays[i], gtk_plot_array_get_double(array), nrows, type);
      } 
      if(type == GTK_TYPE_STRING){
        gtk_plot_array_set(used_arrays[i], gtk_plot_array_get_string(array), nrows, type);
      }
      array->own_data = FALSE;
      g_object_unref(G_OBJECT(array));
    }
  }
 
  sg_dataset_refresh_arrays(dataset); 
  if(GTK_IS_WIDGET(sheet)) gtk_widget_destroy(GTK_WIDGET(sheet));

/* Debugging
  list = dataset->arrays->arrays;
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(strcmp(array->name,"x") == 0){
      for(i = 0; i < array->size; i++) printf("POINT %d %f\n",i,array->data.data_double[i]);
    }
    list = list->next;
  }
*/
}
