/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <math.h>
#include "sg_append_dialog.h"
#include "sg.h"
#include "sg_dialog.h"
#include "sg_stock.h"

typedef struct
{
  GtkWidget *append_spin;
  gint orientation;
  SGworksheet *worksheet;
} SGappendDialog;

static void
update_worksheet(SGpropertyDialog *pdialog, gpointer data)
{
  SGappendDialog *dialog = (SGappendDialog *)data;
  GtkSheet *sheet;
  gint n;

  sheet = GTK_SHEET(dialog->worksheet);

  n = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->append_spin));

  if(dialog->orientation == GTK_ORIENTATION_HORIZONTAL)
    sg_worksheet_add_columns(dialog->worksheet, n);
  else
    sg_worksheet_add_rows(dialog->worksheet, n);
}


void
sg_append_dialog (SGworksheet *worksheet, gint orientation)
{
  GtkWidget *wdialog;
  SGappendDialog *dialog;
  GtkWindow *window;
  GtkWidget *frame;
  GtkWidget *table;
  GtkAdjustment *adj;
  GtkRequisition req;
  gchar text[200];
  gchar title[200];

  if (orientation == GTK_ORIENTATION_HORIZONTAL)
    sprintf(title, _("SciGraphica: Append columns") );
  else
    sprintf(title, _("SciGraphica: Append rows") );

  /* Create widgets */
  dialog = g_new0(SGappendDialog, 1);
  dialog->orientation = orientation;
  dialog->worksheet = worksheet;

  frame = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, TRUE);

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 99999., 1., 0., 0.); 
  dialog->append_spin = gtk_spin_button_new(adj, 0, 0);   
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->append_spin), TRUE);

  gtk_widget_size_request(dialog->append_spin, &req);
  gtk_widget_set_usize(dialog->append_spin, req.width, req.height);

  if(orientation == GTK_ORIENTATION_HORIZONTAL)
    sprintf(text, "Number of columns");
  else
    sprintf(text, "Number of rows");

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(text),
                            0, 2, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->append_spin, 0, 2, 1, 2);

  wdialog = sg_dialog_new (title, GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  window = GTK_WINDOW(wdialog);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  /* connect signals */
  SG_PROPERTY_DIALOG(frame)->ok = update_worksheet;
  sg_dialog_add(wdialog, SG_PROPERTY_DIALOG(frame));

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->append_spin), 1);

  /* Show widgets */

  gtk_widget_show_all(frame);
  sg_dialog_run(wdialog, GTK_OBJECT(worksheet));
}

