/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_formula_dialog.h"
#include "sg_file_dialog.h"
#include "sg_clipboard.h"
#include "pixmaps/open.xpm"
#include "pixmaps/save.xpm"
#include "pixmaps/cut.xpm"
#include "pixmaps/copy.xpm"
#include "pixmaps/paste.xpm"
#include "pixmaps/add_column.xpm"
#include "pixmaps/set_column.xpm"
#include "pixmaps/reload.xpm"

void
worksheet_toolbar_import (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  GtkWidget *filesel = NULL;
  if(GTK_IS_SG_MATRIX(worksheet))
    filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, NULL, "SGmatrix", G_OBJECT(worksheet));
  else
    filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, NULL, "SGworksheet", G_OBJECT(worksheet));
  sg_file_dialog_run(filesel);
}

void
worksheet_toolbar_import_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, open_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_export (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  GtkWidget *filesel = NULL;
  if(GTK_IS_SG_MATRIX(worksheet))
    filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGmatrix", G_OBJECT(worksheet));
  else
    filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGworksheet", G_OBJECT(worksheet));
  sg_file_dialog_run(filesel);
}

void
worksheet_toolbar_export_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, save_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_add_column (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  sg_worksheet_add_columns(worksheet, 1);
  gtk_sheet_select_column(GTK_SHEET(worksheet), 
			  GTK_SHEET(worksheet)->maxcol);
}

void
worksheet_toolbar_add_column_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, add_column_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_set_column (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;

  if(GTK_SHEET(worksheet)->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(worksheet, GTK_SHEET(worksheet)->range.col0);

}

void
worksheet_toolbar_set_column_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, set_column_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_cut (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  sg_worksheet_copy(worksheet,TRUE);
}

void
worksheet_toolbar_cut_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, cut_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_copy (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  sg_worksheet_copy(worksheet,FALSE);
}

void
worksheet_toolbar_copy_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, copy_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_paste (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  sg_worksheet_paste(worksheet);
}

void
worksheet_toolbar_paste_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, paste_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
worksheet_toolbar_recalc (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{ 
  SGworksheetWindow *window = SG_WORKSHEET_WINDOW(g_object_get_data(G_OBJECT(widget), "worksheet"));
  SGworksheet *worksheet = window->worksheet;
  GtkSheet *sheet;
  sheet=GTK_SHEET(worksheet);
  
  sg_worksheet_unupdate_exp_range(worksheet,
               sheet->range.row0,sheet->range.rowi,
               sheet->range.col0,sheet->range.coli);

  sg_worksheet_update_exp_range(worksheet,
               sheet->range.row0,sheet->range.rowi,
               sheet->range.col0,sheet->range.coli);
}

void
worksheet_toolbar_recalc_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, reload_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

