/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>

#include "sg.h"  
#include "sg_arrange_dialog.h"
#include "sg_fit_dialog.h"
#include "sg_file_dialog.h"
#include "sg_layer.h"
#include "sg_text_dialog.h"   
#include "sg_clipboard.h"
#include "sg_plugin_menu.h"
#include "pixmaps/new_2d.xpm"
#include "pixmaps/new_3d.xpm"
#include "pixmaps/new_polar.xpm"
#include "pixmaps/print.xpm"
#include "pixmaps/reload.xpm"
#include "pixmaps/layer_control.xpm"
#include "pixmaps/zoomin.xpm"
#include "pixmaps/zoomout.xpm"
#include "pixmaps/arrange.xpm"
#include "pixmaps/fit_page.xpm"
#include "pixmaps/curve_fit.xpm"

void
plot_toolbar_print (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;
  GtkWidget *filesel;
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGplot", G_OBJECT(plot));
  sg_file_dialog_run(filesel);
}

void
plot_toolbar_print_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
/*
  GdkPixbuf *pixbuf;
  GtkWidget *image;
  image = gtk_image_new_from_stock(GTK_STOCK_PRINT, GTK_ICON_SIZE_LARGE_TOOLBAR);
  pixbuf = gtk_widget_render_icon (image,
                                   GTK_IMAGE(image)->data.stock.stock_id,
                                   GTK_IMAGE(image)->icon_size,
                                   NULL);
  gdk_pixbuf_render_pixmap_and_mask(pixbuf, &pixmap, &mask, 0);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gtk_widget_destroy(image);
  gdk_pixbuf_unref(pixbuf);
*/  
  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, print_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}


void
plot_toolbar_new_2d (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGlayer *layer;
  SGplot *plot = plot_window->plot;

  layer = sg_layer_new(sg_plugin_layer_get("layer_2d"), .65, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_toolbar_new_2d_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_2d_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_new_3d (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGlayer *layer;
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  layer = sg_layer_new(sg_plugin_layer_get("layer_3d"), .65, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_toolbar_new_3d_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_3d_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_new_polar (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGlayer *layer;
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  layer = sg_layer_new(sg_plugin_layer_get("layer_polar"), .75, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_toolbar_new_polar_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_polar_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_refresh (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  sg_plot_refresh_datasets(plot);
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_toolbar_refresh_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, reload_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_arrange (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  sg_arrange_dialog(plot);
}

void
plot_toolbar_arrange_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, arrange_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_fit (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));

  sg_plot_window_fit_page(SG_PLOT_WINDOW(plot_window));
}

void
plot_toolbar_fit_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, fit_page_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_layer_control (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  gchar path[2000];
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;
  GtkObject *dialog;

  g_snprintf(path, 2000, "%s", plot->name);

  sg_plot_layer_control(plot, path);
}

void
plot_toolbar_layer_control_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, layer_control_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_zoom_in (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  sg_plot_rescale(plot, plot->scale + .1);
}

void
plot_toolbar_zoom_in_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, zoomin_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_zoom_out (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  sg_plot_rescale(plot, plot->scale - .1);
}

void
plot_toolbar_zoom_out_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, zoomout_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_curve_fit_init(SGplugin *_plugin)
{
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, curve_fit);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));

  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_toolbar_curve_fit (SGpluginMenu *plugin, GtkWidget *widget, gpointer _data)
{
  SGplotWindow *plot_window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(widget), "plot"));
  SGplot *plot = plot_window->plot;

  sg_fit_dialog(plot);
}

