/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_style_dialog.h>
#include "pixmaps/g_bars.xpm"
#include <sg_data_labels_dialog.h>
#include <sg_errbars_dialog.h>
#include <sg_bars_dialog.h>

GtkPlotData *
vbars_2d_construct()
{
  GtkPlotData *dataset;
  dataset = GTK_PLOT_DATA(gtk_plot_bar_new(GTK_ORIENTATION_VERTICAL));

  dataset->symbol.symbol_style = GTK_PLOT_SYMBOL_FILLED;
  dataset->line.line_style = GTK_PLOT_LINE_NONE;
                                                                                
  return dataset;
}

void
vbars_2d_init(SGplugin *_plugin)
{
  SGpluginStyle *plugin = SG_PLUGIN_STYLE(_plugin);
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;

  colormap = gdk_colormap_get_system();

  plugin->layer = g_strdup("layer_2d");

  sg_plugin_style_add_dimension(plugin, "x", "X", "X values", GTK_TYPE_DOUBLE, TRUE, TRUE);
  sg_plugin_style_add_dimension(plugin, "y", "Y", "Y values", GTK_TYPE_DOUBLE, TRUE, FALSE);
  sg_plugin_style_add_dimension(plugin, "dy", "ErrY", "Error in Y", GTK_TYPE_DOUBLE, FALSE, FALSE);
  sg_plugin_style_add_dimension(plugin, "labels", "Lbls", "Labels", GTK_TYPE_STRING, FALSE, FALSE);


  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, NULL, NULL, g_bars_xpm);

  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, NULL));
  gdk_pixmap_unref(pixmap);
}

static void
dialog_ok(SGpropertyDialog *pdialog, gpointer data)
{
  gint i;
  SGpropertyDialog **dialogs = (SGpropertyDialog **)data;

  for(i = 0; i < 3; i++)
    sg_property_dialog_apply(dialogs[i]);

};

GtkWidget * 	
vbars_2d_dialog(SGpluginStyle *plugin, GtkPlotData *data)
{
  GtkWidget *notebook;
  GtkWidget **dialogs;
  GtkWidget *the_dialog;

  dialogs = g_new0(GtkWidget *, 5);

  the_dialog = sg_property_dialog_new();
  notebook = gtk_notebook_new();
  gtk_container_add(GTK_CONTAINER(the_dialog), notebook);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[0] = sg_bars_dialog_new(data),
                           gtk_label_new( _("Symbols") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[1] = sg_errbars_dialog_new(data, FALSE, TRUE, FALSE),
                           gtk_label_new( _("Error bars") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[2] = sg_data_labels_dialog_new(data, TRUE),
                           gtk_label_new( _("Labels") ));

  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(the_dialog), dialogs, TRUE);
  SG_PROPERTY_DIALOG(the_dialog)->ok = dialog_ok;
  SG_PROPERTY_DIALOG(the_dialog)->apply = dialog_ok;

  return the_dialog;
}

