/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_style_dialog.h>
#include "sg_delaunay.h"
#include "pixmaps/g_surface.xpm"
#include <sg_data_labels_dialog.h>
#include <sg_surface_dialog.h>
#include <sg_gradient_dialog.h>


GtkPlotData *
surface_3d_construct()
{
  GtkPlotData *data;
  data = GTK_PLOT_DATA(gtk_plot_surface_new());
  GTK_PLOT_SURFACE(data)->use_height_gradient = TRUE;
  GTK_PLOT_SURFACE(data)->show_grid = TRUE;
  GTK_PLOT_SURFACE(data)->show_mesh = TRUE;
  GTK_PLOT_SURFACE(data)->transparent = FALSE;

  gtk_object_destroy(GTK_OBJECT(GTK_PLOT_SURFACE(data)->dt)); 
  GTK_PLOT_SURFACE(data)->dt = GTK_PLOT_DT(sg_delaunay_new());
  return data;
}

void
surface_3d_init(SGplugin *_plugin)
{
  SGpluginStyle *plugin = SG_PLUGIN_STYLE(_plugin);
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;

  colormap = gdk_colormap_get_system();

  plugin->layer = g_strdup("layer_3d");

  sg_plugin_style_add_dimension(plugin, "x", "X", "X values", GTK_TYPE_DOUBLE, TRUE, TRUE);
  sg_plugin_style_add_dimension(plugin, "y", "Y", "Y values", GTK_TYPE_DOUBLE, TRUE, TRUE);
  sg_plugin_style_add_dimension(plugin, "z", "Z", "Z values", GTK_TYPE_DOUBLE, TRUE, FALSE);
  sg_plugin_style_add_dimension(plugin, "da", "Amp", "Color", GTK_TYPE_DOUBLE, FALSE, FALSE);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, NULL, NULL, g_surface_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, NULL));
  gdk_pixmap_unref(pixmap);
}

static void
dialog_ok(SGpropertyDialog *pdialog, gpointer data)
{
  gint i;
  SGpropertyDialog **dialogs = (SGpropertyDialog **)data;

  for(i = 0; i < 4; i++)
    sg_property_dialog_apply(dialogs[i]);

};

GtkWidget * 	
surface_3d_dialog(SGpluginStyle *plugin, GtkPlotData *data)
{
  GtkWidget *notebook;
  GtkWidget **dialogs;
  GtkWidget *the_dialog;

  dialogs = g_new0(GtkWidget *, 5);

  the_dialog = sg_property_dialog_new();
  notebook = gtk_notebook_new();
  gtk_container_add(GTK_CONTAINER(the_dialog), notebook);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[0] = sg_surface_dialog_new(data, FALSE, TRUE, TRUE),
                           gtk_label_new( _("Surface") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[1] = sg_gradient_dialog_new(data, 0),
                           gtk_label_new( _("Levels+Colors") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[2] = sg_gradient_labels_dialog_new(data),
                           gtk_label_new( _("Gradient format") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[3] = sg_data_labels_dialog_new(data, TRUE),
                           gtk_label_new( _("Labels") ));

  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(the_dialog), dialogs, TRUE);
  SG_PROPERTY_DIALOG(the_dialog)->ok = dialog_ok;
  SG_PROPERTY_DIALOG(the_dialog)->apply = dialog_ok;
  
  return the_dialog;
}

