/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "config.h"

#include "sg.h"  
#include "sg_arrange_dialog.h"
#include "sg_file_dialog.h"
#include "sg_misc_dialogs.h"
#include "sg_dataset_dialog.h"
#include "sg_layer.h"
#include "sg_text_dialog.h"   
#include "sg_clipboard.h"
#include "sg_plugin_menu.h"
#include "sg_fit_dialog.h"
#include "sg_data_expr_dialog.h"
#include "pixmaps/new_2d_small.xpm"
#include "pixmaps/new_3d_small.xpm"
#include "pixmaps/new_polar_small.xpm"

void
plot_popup_fit_page(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  SGplotWindow *window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(plot), "window"));
  sg_plot_window_fit_page(window);
}

void
plot_popup_fit_page_h(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  SGplotWindow *window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(plot), "window"));
  sg_plot_window_fit_page_h(window);
}

void
plot_popup_fit_page_v(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  SGplotWindow *window = SG_PLOT_WINDOW(g_object_get_data(G_OBJECT(plot), "window"));
  sg_plot_window_fit_page_v(window);
}


void
plot_popup_arrange(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_arrange_dialog(SG_PLOT(plot));
}

void
plot_popup_clone(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = sg_layer_clone(plot->active_layer);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_new_2d(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = sg_layer_new(sg_plugin_layer_get("layer_2d"), .65, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_new_2d_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_2d_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_popup_new_3d(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = sg_layer_new(sg_plugin_layer_get("layer_3d"), .65, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_new_3d_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_3d_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_popup_new_polar(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = sg_layer_new(sg_plugin_layer_new("layer_polar"), .75, .45);
  sg_plot_add_layer(plot, layer, .175, .15);

  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_new_polar_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_polar_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
plot_popup_remove_layer(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  GList *layers = NULL;
  gint selected_layer_nr = 0;
  gchar message[250];
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = plot->active_layer;
  layers = plot->layers;

  while(layers) {
     selected_layer_nr++;
     if(layers->data == layer)
       break;
     else
       layers = layers->next;
  }

  g_snprintf(message, 250, "Remove selected layer nr. %d?", selected_layer_nr);
  if(sg_accept_dialog(message, 1) == SG_BUTTON_YES)
       sg_plot_remove_layer(plot, layer);

  if(plot->nlayers > 0 && plot->layers)
    sg_plot_set_active_layer(plot, (SGlayer *)plot->layers->data); 
}

void
plot_popup_layer_control(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  GList *llink;
  gchar path[1000];
  GtkObject *dialog;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = plot->active_layer;
  llink = g_list_find(plot->layers, layer);
  sprintf(path, "%s:%d", plot->name,
          g_list_position(plot->layers, llink)+1);

  sg_plot_layer_control(plot, path);
}

void
plot_popup_layer_remove_markers(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  GList *list;

  layer = plot->active_layer;
  list = GTK_PLOT_CANVAS_PLOT(layer)->plot->data_sets;
  while(list) {
    gtk_plot_data_remove_markers(GTK_PLOT_DATA(list->data));
    list = list->next;
  }
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_open(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  GObject *o = G_OBJECT(plot);
  GtkWidget *filesel;

  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_OPEN, NULL, "SGplot", o);
  sg_file_dialog_run(filesel);
}

void
plot_popup_import(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  GObject *o = G_OBJECT(plot);
  GtkWidget *filesel;

  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, NULL, "SGplot", o);
  sg_file_dialog_run(filesel);
}

void
plot_popup_export(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  GObject *o = G_OBJECT(plot);
  GtkWidget *filesel;

  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGplot", o);
  sg_file_dialog_run(filesel);
}

void
plot_popup_copy_page(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_copy(plot);
}

void
plot_popup_paste(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_paste(plot, 0., 0.);
}

void
plot_popup_image(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  GtkWidget *filesel;
  GtkPixmap *pixmap;
  gboolean return_value;

  pixmap = GTK_PIXMAP(gtk_pixmap_new(gdk_pixmap_new(menu->window, 10, 10, -1), NULL));
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_OPEN, NULL, "image", G_OBJECT(pixmap));
  return_value = sg_file_dialog_run(filesel);
  if(return_value) 
    sg_plot_put_pixmap(plot, pixmap->pixmap);
  else
    gtk_widget_unref(GTK_WIDGET(pixmap));
}

/*
#ifdef WITH_GNOME_PRINT
#ifdef WITH_GNOME
void
plot_popup_preview(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  GtkWidget *toplevel, *gcanvas, *sw;
  GtkPlotCanvas *canvas;
  GtkPlotPC *pc;
  GList *plots;
  gint old_width, old_height;
  GtkAllocation allocation[100];
  gdouble m;
  gint n;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  canvas = GTK_PLOT_CANVAS(plot);
  m = canvas->magnification;
  old_width = canvas->pixmap_width;
  old_height = canvas->pixmap_height;

  canvas->magnification = 1.0;
  canvas->pixmap_width = canvas->width;
  canvas->pixmap_height = canvas->height;

  n = 0;
  plots = canvas->plots;
  while(plots)
     {
       GtkPlot *plot;

       plot = (GtkPlot *)plots->data;

       plot->magnification =  1.0;

       allocation[n].width = GTK_WIDGET(plot)->allocation.width;
       allocation[n].height = GTK_WIDGET(plot)->allocation.height;
       n++;

       GTK_WIDGET(plot)->allocation.width = canvas->width;
       GTK_WIDGET(plot)->allocation.height = canvas->height;

       plots = plots->next;
     }

  gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
  gtk_widget_set_default_visual (gdk_rgb_get_visual ());

  toplevel = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (toplevel, canvas->width, canvas->height);

  sw = gtk_scrolled_window_new (NULL, NULL);
  gcanvas = gnome_canvas_new_aa ();
  gtk_container_add (GTK_CONTAINER (toplevel), sw);
  gtk_container_add (GTK_CONTAINER (sw), gcanvas);

  gtk_widget_show_all (toplevel);
  pc = canvas->pc; 
  canvas->pc = GTK_PLOT_PC(gtk_plot_gnome_preview_new(GNOME_CANVAS(gcanvas), 0, plot->page_size));


  gtk_plot_canvas_paint(canvas);

  g_object_destroy(G_OBJECT(canvas->pc));
  canvas->pc = pc;

  canvas->magnification = m;
  canvas->pixmap_width = old_width;
  canvas->pixmap_height = old_height;

  n = 0;
  plots = canvas->plots;
  while(plots)
     {
       GtkPlot *plot;

       plot = (GtkPlot *)plots->data;
       plot->magnification =  m;

       GTK_WIDGET(plot)->allocation.width = allocation[n].width;
       GTK_WIDGET(plot)->allocation.height = allocation[n].height;
       n++;

       plots = plots->next;
     }
}
*/
//#endif /* WITH_GNOME */
//#endif /* WITH_GNOME_PRINT */


#ifdef WITH_LIBART
void
plot_popup_view_normal(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_antialias(plot, FALSE);
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_view_antialias(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_antialias(plot, TRUE);
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}
#endif

void
plot_popup_zoom_in(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_rescale(plot, plot->scale + .1);
}

void
plot_popup_zoom_out(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));
  sg_plot_rescale(plot, plot->scale - .1);
}

void
plot_popup_add(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGlayer *layer;
  GList *llink;
  gchar path[1000];
  GtkObject *dialog;
  SGdataset *dataset;
  gpointer data;
  SGapplication *app = NULL;

  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  layer = plot->active_layer;
  llink = g_list_find(plot->layers, layer);
  sprintf(path, "%s:%d:dataset", plot->name,
          g_list_position(plot->layers, llink)+1);

/*
  sg_plot_layer_control(plot, path);
*/

  data = g_object_get_data(G_OBJECT(plot), "application");
  if(data) app = SG_APPLICATION(data);
  dataset = sg_dataset_dialog(app, layer->plugin);
  if(dataset) {
    GtkPlotData *plot_data;
    sg_list_add(app->datasets, G_OBJECT(dataset), dataset->name);
    plot_data = sg_layer_add_dataset_autosymbol(layer, dataset);
    sg_dataset_refresh(dataset);
  }
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(plot));
  gtk_widget_queue_draw(GTK_WIDGET(plot));
}

void
plot_popup_fit(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  sg_fit_dialog(plot);
}


void
plot_popup_page(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  gchar *path;
  GtkObject *dialog;
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  path = plot->name;

  sg_plot_layer_control(plot, path);
}

void
plot_popup_expression(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGplot *plot = SG_PLOT(g_object_get_data(G_OBJECT(menu), "plot"));

  sg_data_expr_dialog(plot);
}
