/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_matrix_dialog.h"
#include "sg_column_dialog.h"
#include "sg_formula_dialog.h"
#include "sg_xy_formula_dialog.h"
#include "sg_misc_dialogs.h"
#include "sg_clipboard.h"
#include "sg_matrix_convert.h"
#include "sg_file_dialog.h"
#include "sg_append_dialog.h"
#include "sg_plugin_menu.h"

void
matrix_popup_append_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_append_dialog(worksheet, GTK_ORIENTATION_VERTICAL);
}

void
matrix_popup_append_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_append_dialog(worksheet, GTK_ORIENTATION_HORIZONTAL);
}

void
matrix_popup_insert_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(worksheet);
  range = sheet->range;

  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return;

  sg_worksheet_insert_rows(worksheet, sheet->range.row0,
                           sheet->range.rowi - sheet->range.row0 + 1);
}

void
matrix_popup_insert_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED){
    sg_worksheet_insert_columns(worksheet, sheet->range.col0,
                                sheet->range.coli - sheet->range.col0 + 1);
  }
}

void
matrix_popup_remove_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(worksheet);

  if(sheet->maxrow < 2) return;

  range = sheet->range;
  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return;

  sg_worksheet_delete_rows(worksheet, sheet->range.row0, nrows);
}

void
matrix_popup_remove_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint ncols;
  
  sheet = GTK_SHEET(worksheet);

  if(sheet->maxcol < 2) return;

  range = sheet->range;
  ncols = range.coli - range.col0 + 1;

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
    sg_worksheet_delete_columns(worksheet, sheet->range.col0, ncols);
}

/*
void
matrix_popup_begin(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  sg_worksheet_set_begin(worksheet, sheet->range.row0);
}

void
matrix_popup_end(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  sg_worksheet_set_end(worksheet, sheet->range.row0);
}

void
matrix_popup_reset(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_reset(worksheet);
}
*/

void
matrix_popup_cut(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_copy(worksheet, TRUE);
}

void
matrix_popup_copy(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_copy(worksheet, FALSE);
}

void
matrix_popup_paste(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_paste(worksheet);
}

void
matrix_popup_clear(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  gtk_sheet_range_clear(sheet, &sheet->range);
}

void
matrix_popup_clear_all(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  gtk_sheet_range_clear(sheet, NULL);
}

void
matrix_popup_properties(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_column_dialog(worksheet, 0);
}

void
matrix_popup_set_values(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  sheet = GTK_SHEET(worksheet);
  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(worksheet, sheet->range.col0);
}

void
matrix_popup_set_mvalues(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_xy_formula_dialog(worksheet);
}

void
matrix_popup_set_range(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_matrix_dialog(SG_MATRIX(worksheet));
}

void
matrix_popup_mask(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(worksheet, sheet->range.col0);
}

void
matrix_popup_export(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkWidget *filesel;

  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGmatrix", G_OBJECT(worksheet));
  sg_file_dialog_run(filesel);
}

void
matrix_popup_import(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkWidget *filesel;

  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, NULL, "SGmatrix", G_OBJECT(worksheet));
  sg_file_dialog_run(filesel);
}

void
matrix_popup_ascii(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
/* FIXME
  sg_import_dialog(NULL,NULL);
*/
}


void
matrix_popup_transpose(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_matrix_transpose(worksheet);
}

void
matrix_popup_convert(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_matrix_to_worksheet(worksheet);
}
