/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_data_edit_dialog.h>
#include "sg_edit_dialog.h"
#include "sg_dataset_worksheet.h"

#define DATASET_NAME_LENGTH 100
#define NCOLUMNS 12

static void
refresh_name(SGdataset *dataset)
{
  gint i;
  gchar name[200];
  gchar column_text[20][200];
  GParamSpec **args;
  gint nargs;
  GList *list;
  gchar *description;
  gpointer arg_pointer;
  gchar *arg_name[] = {"col_00","col_01","col_02","col_03","col_04","col_05","col_06","col_07","col_08","col_09","col_10","col_11"};

  sg_dataset_refresh(dataset);

  args = g_object_class_list_properties(G_OBJECT_GET_CLASS(G_OBJECT(dataset)), &nargs);

  for(i = 0; i < NCOLUMNS; i++) column_text[i][0] = '\0';

  g_object_get(G_OBJECT(dataset), "SGdatasetWorksheet::worksheet", &arg_pointer, NULL);
  g_snprintf(name, 200, "Worksheet:%s\n", 
                         SG_WORKSHEET(arg_pointer)->name);
  description = g_strdup(name);

  list = SG_DATASET(dataset)->constructor->arrays->arrays;
  i = 0;
  while(list){
    gchar *column_name;
    GtkPlotArray * dim = GTK_PLOT_ARRAY(list->data);
    gint arg_int;

    g_object_get(G_OBJECT(dataset), arg_name[i], &arg_int, NULL);

    if(arg_int != -1){
      column_name = GTK_SHEET(arg_pointer)->column[arg_int].name;
      if(column_name){
        if(i == 0)
          g_snprintf(column_text[i], 200, "%s(%s)", column_name, dim->name);
        else
          g_snprintf(column_text[i], 200, ",%s(%s)", column_name, dim->name);
      }
      g_snprintf(name, 200, "Dim %s : col(%s)\n", dim->name, column_name);
      description = g_strconcat(description, name, NULL);
    }
    list = list->next;
    i++;
  }

  g_snprintf(name, 200, "%s:%s->%s%s%s%s%s%s%s%s%s",
                         SG_PLUGIN(SG_DATASET(dataset)->constructor)->name,
                         SG_WORKSHEET(arg_pointer)->name,
                         column_text[0],
                         column_text[1],
                         column_text[2],
                         column_text[3],
                         column_text[4],
                         column_text[5],
                         column_text[6],
                         column_text[7],
                         column_text[8]);

  sg_dataset_set_name(SG_DATASET(dataset), name);
  sg_dataset_set_description(SG_DATASET(dataset), description);
  g_free(description);
  g_free(args);
}


SGdataset*
sg_dataset_worksheet_new_dialog(SGpluginIterator *plugin, SGpluginStyle *style, SGapplication *app)
{
  SGdataset *dataset, *new_dataset = NULL;

  dataset = sg_plugin_iterator_construct(plugin, style);
  new_dataset = sg_edit_columns_dialog(app, dataset);
  if(new_dataset)
    refresh_name(new_dataset);
  else
    g_object_unref(G_OBJECT(dataset));
  return new_dataset;
}

SGdataset*
sg_dataset_worksheet_edit_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  SGdataset *return_data = NULL;

  return_data = sg_edit_columns_dialog(app, dataset);
  if(!return_data) 
    return_data = dataset;
  else
    refresh_name(return_data);
  return return_data;
}

void
sg_dataset_worksheet_edit_data_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  sg_data_edit_dialog(dataset);
}


