/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_data_edit_dialog.h>
#include "sg_dataset_matrix.h"

#define DATASET_NAME_LENGTH 100

typedef struct
{
  SGdataset *dataset;
  SGapplication *app;
  GtkWidget *matrix_list;
  SGpluginStyle *constructor;
  SGpluginIterator *plugin;
  SGmatrix *matrix;
} SGmatrixDialog;

static void
ok_pressed(SGpropertyDialog *wdialog, gpointer data)
{
  SGmatrixDialog *dialog = (SGmatrixDialog *)data;
  SGworksheet *matrix = NULL;
  gchar name[2000];
  GList *selection;
  gint row;

  selection = GTK_CLIST(dialog->matrix_list)->selection;
  if(!selection) return;

  row = GPOINTER_TO_INT(selection->data);
  matrix = SG_WORKSHEET(gtk_clist_get_row_data(GTK_CLIST(dialog->matrix_list), row));

  if(!matrix) {
    dialog->dataset = NULL;
    return;
  }

  g_snprintf(name, 2000, "%s:%s",
                         SG_PLUGIN(SG_DATASET(dialog->dataset)->constructor)->name,
                         SG_WORKSHEET(matrix)->name);
  sg_dataset_set_name(SG_DATASET(dialog->dataset), name);
  g_snprintf(name, 2000, "Style:%s\nMatrix:%s",
                         SG_PLUGIN(SG_DATASET(dialog->dataset)->constructor)->name,
                         SG_WORKSHEET(matrix)->name);
  sg_dataset_set_description(SG_DATASET(dialog->dataset), name);

  g_object_set(G_OBJECT(dialog->dataset), "SGdatasetMatrix::matrix", matrix, NULL);
  sg_dataset_refresh(dialog->dataset);
}

static SGdataset *
sg_dataset_from_matrix (SGmatrixDialog *dialog)
{ 
  GtkWidget *wdialog;
  GtkWidget *pdialog;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *vbox, *box, *sw;
  GtkWidget *entries_box;
  SGmatrix *matrix = NULL;
  SGdialogButton return_val;
  GList *list;

  /* Create widgets */

  pdialog = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (pdialog), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(pdialog), dialog, FALSE);
  SG_PROPERTY_DIALOG(pdialog)->ok = ok_pressed;

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(pdialog), vbox);
/*********************************************************************/

  box = gtk_hbox_new(TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box, FALSE, FALSE, 0);

  label = gtk_label_new( _("Dataset Style:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);

/*********************************************************************/
  frame = gtk_frame_new( _("Select Matrix") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  entries_box = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(entries_box), 5);
  gtk_container_add (GTK_CONTAINER (frame), entries_box);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(sw, 240, 160);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (entries_box), sw, FALSE, FALSE, 0);

  dialog->matrix_list = gtk_clist_new(1);
  gtk_container_add(GTK_CONTAINER(sw), dialog->matrix_list);

  if(dialog->dataset){
    gpointer arg_value;
    g_object_get(G_OBJECT(dialog->dataset), "SGdatasetMatrix::matrix", &arg_value, NULL);
    if(arg_value)
      matrix = SG_MATRIX(arg_value);
  }

  list = dialog->app->worksheets->list;
  while(list){
   SGlistChild *child = (SGlistChild *)list->data;
   SGworksheet *worksheet;

   worksheet = SG_WORKSHEET(child->object);
   if(GTK_IS_SG_MATRIX(worksheet)){
     gtk_clist_append(GTK_CLIST(dialog->matrix_list), &worksheet->name);
     gtk_clist_set_row_data(GTK_CLIST(dialog->matrix_list), GTK_CLIST(dialog->matrix_list)->rows-1, worksheet);
     if(dialog->dataset && matrix == SG_MATRIX(worksheet)){
       gtk_clist_select_row(GTK_CLIST(dialog->matrix_list), GTK_CLIST(dialog->matrix_list)->rows-1, 0);
     }
   }
   list = list->next;
  }

/********************************************************************/
  wdialog = sg_dialog_new(_("SciGraphica: New dataset"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  gtk_window_set_policy(GTK_WINDOW(wdialog), FALSE, FALSE, FALSE);
  gtk_window_set_position(GTK_WINDOW(wdialog), GTK_WIN_POS_CENTER);
  sg_dialog_add(wdialog, SG_PROPERTY_DIALOG(pdialog));
  gtk_widget_show_all(pdialog);

  /* Show widgets */

  return_val = sg_dialog_run(wdialog, NULL);

  if(return_val == SG_BUTTON_CANCEL){
     dialog->dataset = NULL;
  }

  return dialog->dataset;
}

SGdataset*
sg_dataset_matrix_new_dialog(SGpluginIterator *plugin, SGpluginStyle* style, SGapplication *app)
{
  SGmatrixDialog *dialog = NULL;
  SGdataset *dataset;
  SGdataset *return_data = NULL;

  dialog = g_new0(SGmatrixDialog, 1);
  dialog->plugin = plugin;
  dialog->app = app;

  dataset = sg_plugin_iterator_construct(plugin, style);
  dialog->dataset = dataset;
  dialog->constructor = style;
  dialog->matrix = NULL;
  return_data = sg_dataset_from_matrix(dialog);

  if(!return_data)
    g_object_unref(G_OBJECT(dataset));

  g_free(dialog);
  return return_data;
}

SGdataset*
sg_dataset_matrix_edit_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  SGmatrixDialog *dialog;
  SGdataset *return_data = NULL;

  dialog = g_new0(SGmatrixDialog, 1);
  dialog->plugin = plugin;
  dialog->app = app;
  dialog->dataset = dataset;
  dialog->constructor = dataset->constructor;
  dialog->matrix = SG_DATASET_MATRIX(dataset)->matrix;
  return_data = sg_dataset_from_matrix(dialog);
  g_free(dialog);
  return return_data;
}

void
sg_dataset_matrix_edit_data_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  sg_data_edit_dialog(dataset);
}
                                                                               

