/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include "sg_dataset_function.h"

#define DATASET_NAME_LENGTH 100

typedef struct
{
  SGdataset *dataset;
  SGapplication *app;
  GtkWidget *exp_entry;
  SGpluginIterator *plugin;
  SGpluginStyle *constructor;
  gboolean old_dataset;
} SGfunctionDialog;

static void 
ok_pressed(SGpropertyDialog *wdialog, gpointer data)
{
  SGfunctionDialog *dialog = (SGfunctionDialog *) data;
  const gchar *text;
  SGdataset *new_dataset; 
  GtkPlotArray *new_dim;
  GtkPlotArrayList *arrays;
  gchar description[2000];

  arrays = GTK_PLOT_ARRAY_LIST(gtk_plot_array_list_new());

  text = gtk_entry_get_text(GTK_ENTRY(dialog->exp_entry));
  if(!text || strlen(text) == 0){
    if(dialog->dataset && !dialog->old_dataset) g_object_unref(G_OBJECT(dialog->dataset));
    dialog->dataset = NULL;
    return;
  }

  if(dialog->dataset){
     g_object_set(G_OBJECT(dialog->dataset), "SGdatasetFunction::exp", text, NULL);
  } else {
     new_dataset = sg_plugin_iterator_construct(dialog->plugin, dialog->constructor);
     g_object_set(G_OBJECT(dialog->dataset), "SGdatasetFunction::exp", text, NULL);
     g_object_set(G_OBJECT(new_dataset), "SGdatasetFunction::exp", text, NULL);
     dialog->dataset = new_dataset;
  }
  g_snprintf(description, 2000, "%s = %s", dialog->dataset->name, text);
  sg_dataset_set_description(dialog->dataset, description);

  new_dim = GTK_PLOT_ARRAY(gtk_plot_array_new("x", NULL, 0, GTK_TYPE_DOUBLE, TRUE));
  gtk_plot_array_set_label(new_dim, "X");
  gtk_plot_array_set_description(new_dim, "X Values");
  gtk_plot_array_set_required(new_dim, TRUE);
  gtk_plot_array_list_add(arrays, new_dim);
  g_object_unref(G_OBJECT(new_dim));
                                                                                
  new_dim = GTK_PLOT_ARRAY(gtk_plot_array_new("y", NULL, 0, GTK_TYPE_DOUBLE, TRUE));
  gtk_plot_array_set_label(new_dim, "Y");
  gtk_plot_array_set_description(new_dim, "Y Values");
  gtk_plot_array_set_required(new_dim, TRUE);
  gtk_plot_array_list_add(arrays, new_dim);
  g_object_unref(G_OBJECT(new_dim));
  
  sg_dataset_set_arrays(dialog->dataset, arrays);
  g_object_unref(G_OBJECT(arrays));

}

static SGdataset *
sg_dataset_from_function (SGfunctionDialog *dialog)
{
  GtkWidget *wdialog;
  GtkWidget *table;
  GtkWidget *frame;
  GtkWidget *label;
  SGdataset *real_data = NULL;
  gchar text[200];
  GtkArg args[1];
  SGdialogButton return_val;

  if(dialog->dataset) real_data = dialog->dataset;

  /* Create widgets */

  frame = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, FALSE);
  SG_PROPERTY_DIALOG(frame)->ok = ok_pressed;

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  if(real_data){
    g_snprintf(text, 200, "%s = ", real_data->name);
  } else {
    g_snprintf(text, 200, "%s", " ");
  }

  label = gtk_label_new(text);
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_table_attach_defaults(GTK_TABLE(table),
                            label,
                            0, 1, 1, 2);

  dialog->exp_entry = gtk_entry_new();

  if(dialog->dataset){
    gchar *arg_value;
    g_object_get(G_OBJECT(dialog->dataset), "SGdatasetFunction::exp", &arg_value, NULL);
    if(arg_value)
      gtk_entry_set_text(GTK_ENTRY(dialog->exp_entry), arg_value);
  }
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->exp_entry, 1, 4, 1, 2);

/********************************************************************/

  wdialog = sg_dialog_new(_("SciGraphica: Edit Function"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  sg_dialog_add(wdialog, SG_PROPERTY_DIALOG(frame));
  gtk_window_set_policy(GTK_WINDOW(wdialog), FALSE, FALSE, FALSE);
  gtk_window_set_position(GTK_WINDOW(wdialog), GTK_WIN_POS_CENTER);
  gtk_widget_show_all(frame);

  /* wait until dialog get destroyed */
  return_val = sg_dialog_run(wdialog, NULL);

  if(return_val == SG_BUTTON_CANCEL){
     if(dialog->dataset && !dialog->old_dataset) g_object_unref(G_OBJECT(dialog->dataset));
     dialog->dataset = NULL;
  }

  return dialog->dataset;
}

SGdataset*
sg_dataset_function_new_dialog(SGpluginIterator *plugin, SGpluginStyle *style, SGapplication *app)
{
  SGfunctionDialog *dialog;
  SGdataset *dataset = NULL;
  SGdataset *return_data = NULL;
  gchar name[200];

  dialog = g_new0(SGfunctionDialog, 1);
  dialog->plugin = plugin;
  dialog->constructor = style;
  dialog->app = app;
  dialog->old_dataset = FALSE;
  dialog->exp_entry = NULL;

  dataset = sg_plugin_iterator_construct(plugin, style);
  dialog->dataset = dataset;

  g_object_set(G_OBJECT(dataset), "SGdatasetFunction::exp", "0.0", NULL);

/* Refresh name */
  if(dialog->app){
    gchar name[200];
    gint n = 0;
    GList *list = dialog->app->datasets->list;
    while(list){
      SGlistChild *child = (SGlistChild *)list->data;
      if(GTK_IS_SG_DATASET_FUNCTION(child->object)) n++;
      list = list->next;
    }
    g_snprintf(name,200,"f%i(x)",n+1);
    sg_dataset_set_name(dialog->dataset, name);
  } else {
    g_snprintf(name,200,"f(x)");
    sg_dataset_set_name(dataset, name);
  }

  return_data = sg_dataset_from_function(dialog);
  g_free(dialog);
  return return_data;
}

SGdataset*
sg_dataset_function_edit_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  SGfunctionDialog *dialog;
  SGdataset *return_data = NULL;

  dialog = g_new0(SGfunctionDialog, 1);
  dialog->plugin = plugin;
  dialog->constructor = dataset->constructor;
  dialog->app = app;
  dialog->old_dataset = TRUE;
  dialog->dataset = dataset;

  return_data = sg_dataset_from_function(dialog);
  g_free(dialog);
  return return_data;
}

