/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_file_dialog.h>
#include <sg_data_edit_dialog.h>
#include "sg_edit_dialog.h"

SGdataset*
sg_dataset_file_new_dialog(SGpluginIterator *plugin, SGpluginStyle *style, SGapplication *app)
{
  SGdataset *dataset = NULL;
  GtkWidget *filesel = NULL;
  gboolean rvalue;

  dataset = sg_plugin_iterator_construct(plugin, style);
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, app, "sg_dataset", G_OBJECT(dataset));
  rvalue = sg_file_dialog_run(filesel);
  if(!rvalue) {
    g_object_unref(G_OBJECT(dataset));
    dataset = NULL;
  }

  return dataset;
}

void
sg_dataset_file_edit_data_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  sg_data_edit_dialog(dataset);
}
                                                                               

