/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>

typedef struct
{
  SGapplication *app;
  GtkWidget *entries[9];
  GtkWidget *entries_box;
  GtkWidget *entries_table;
  gint num_entries;
  SGdataset *dataset;
  SGpluginStyle *constructor;
} SGpythonDialog;

static void init_exp				(SGpythonDialog *dialog);


static void
sg_edit_python_update(SGpropertyDialog *pdialog, gpointer data)
{
  gint i, narg = 0, ndimensions = 0;
  GtkArg args[9];
  SGpythonDialog *dialog = (SGpythonDialog *)data;

  args[0].name = "SGdatasetPython::exp_x";
  args[1].name = "SGdatasetPython::exp_y";
  args[2].name = "SGdatasetPython::exp_z";
  args[3].name = "SGdatasetPython::exp_a";
  args[4].name = "SGdatasetPython::exp_x";
  args[5].name = "SGdatasetPython::exp_y";
  args[6].name = "SGdatasetPython::exp_z";
  args[7].name = "SGdatasetPython::exp_a";
  args[8].name = "SGdatasetPython::exp_labels";

/* TODO
  for(i = 0; i < 9; i++){
    args[i].type = GTK_TYPE_STRING;
    GTK_VALUE_STRING(args[i]) = NULL;
    if(dialog->constructor->dimensions_required & (1 << i)) ndimensions++;
    if(dialog->constructor->dimensions_mask & (1 << i) && dialog->entries[i]){
       GTK_VALUE_STRING(args[i])= gtk_entry_get_text(GTK_ENTRY(dialog->entries[i]));
       if (strlen(GTK_VALUE_STRING(args[i]))>0) 
         narg++;
    }
  }
*/
  if(narg < ndimensions){
    dialog->dataset = NULL;
    return;
  }

  for(i = 0; i < 9; i++){
    g_object_set(G_OBJECT(dialog->dataset), args[i].name, GTK_VALUE_STRING(args[i]), NULL);
  }
}

SGdataset *
sg_edit_python_dialog (SGapplication *app, SGdataset *dataset)
{
  GtkWidget *window;
  GtkWidget *exp_frame;
  GtkWidget *frame, *vbox;
  GtkWidget *label;
  GtkWidget *box;
  SGpythonDialog *dialog;
  gint i;

  dialog = g_new0(SGpythonDialog, 1);
  dialog->dataset = dataset;
  dialog->app = app;
  dialog->constructor = dataset->constructor;

  /* Create widgets */

  frame = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, TRUE);
  SG_PROPERTY_DIALOG(frame)->apply = sg_edit_python_update;
  SG_PROPERTY_DIALOG(frame)->ok = sg_edit_python_update;

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
  gtk_container_add(GTK_CONTAINER(frame), vbox);

/*********************************************************************/
  box = gtk_hbox_new(TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box, FALSE, FALSE, 0);

  label = gtk_label_new( _("Dataset Style:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), GTK_WIDGET(gtk_pixmap_new(dataset->constructor->pixmap->pixmap, NULL)), FALSE, FALSE, 0);

/*********************************************************************/
  exp_frame = gtk_frame_new( _("Python Expressions") );
  gtk_frame_set_shadow_type (GTK_FRAME (exp_frame), GTK_SHADOW_ETCHED_IN);
  gtk_container_set_border_width(GTK_CONTAINER(exp_frame), 5);
  gtk_box_pack_start (GTK_BOX (vbox), exp_frame, FALSE, FALSE, 0);

  dialog->entries_table = NULL;
  dialog->entries_box = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(dialog->entries_box), 5);
  gtk_container_add (GTK_CONTAINER (exp_frame), dialog->entries_box);

  for(i = 0; i < 9; i++) dialog->entries[i] = NULL;

  init_exp(dialog);

/********************************************************************/
  window = sg_dialog_new( _("SciGraphica: Edit Expressions"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_widget_show_all(frame);

  sg_dialog_add(window, SG_PROPERTY_DIALOG(frame));
  gtk_widget_show_all(frame);
  sg_dialog_run(window, NULL);

  return dialog->dataset;
}

static void
init_exp(SGpythonDialog *dialog)
{
  GtkWidget *column_label;
  gint i = 0, nrows = 0;
  gchar label[9][100];
  GParamSpec **args;
  gint nargs;

  if(dialog->entries_table && GTK_IS_WIDGET(dialog->entries_table))
     gtk_container_remove(GTK_CONTAINER(dialog->entries_box), dialog->entries_table);

/* TODO
  dialog->num_entries = 0;
  for(i = 0; i < 9; i++) 
    if(dialog->dataset->constructor->dimensions_mask & (i << i)) dialog->num_entries++;

  dialog->entries_table = gtk_table_new(dialog->num_entries, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(dialog->entries_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(dialog->entries_table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(dialog->entries_table), 5);

  args = gtk_object_query_args(GTK_OBJECT_TYPE(dialog->dataset), &flags, &nargs);
  gtk_object_getv(GTK_OBJECT(dialog->dataset), nargs, args);

  for(i = 0; i < 9; i++){
    sprintf(label[i], "%s:", dialog->dataset->constructor->dimension_names[i]);
    dialog->entries[i] = NULL;
    if(dialog->dataset->constructor->dimensions_mask & (1 << i)){
      column_label = gtk_label_new(label[i]);
      gtk_misc_set_alignment(GTK_MISC(column_label), .5, .5);
      gtk_table_attach_defaults(GTK_TABLE(dialog->entries_table), column_label, 
                                0, 1, nrows, nrows + 1);    
      dialog->entries[i] = gtk_entry_new();
      gtk_table_attach_defaults(GTK_TABLE(dialog->entries_table), dialog->entries[i], 
                                1, 2, nrows, nrows + 1);    


      if(GTK_VALUE_STRING(args[i]))
        gtk_entry_set_text(GTK_ENTRY(dialog->entries[i]), GTK_VALUE_STRING(args[i]));

      nrows++;
    }
  }
*/
  gtk_box_pack_start(GTK_BOX(dialog->entries_box), dialog->entries_table, FALSE, FALSE, 0);
  gtk_widget_show_all(dialog->entries_table);

  g_free(args);
}

