/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_EDIT_DIALOG_H__
#define __SG_EDIT_DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_dataset.h"
#include "sg_layer.h"
#include "sg_plugin_dataset.h"
#include "sg_application.h"

SGdataset*	sg_new_dataset_file_dialog	(SGpluginDataset *plugin, 
						 SGapplication *app);
SGdataset*	sg_new_dataset_function_dialog	(SGpluginDataset *plugin, 
						 SGapplication *app);
SGdataset*	sg_edit_dataset_function_dialog (SGpluginDataset *plugin, 
						 SGapplication *app,
                                                 SGdataset *dataset);
SGdataset*	sg_new_dataset_worksheet_dialog	(SGpluginDataset *plugin,
						 SGapplication *app);
SGdataset*	sg_edit_dataset_worksheet_dialog(SGpluginDataset *plugin, 
						 SGapplication *app,
                                                 SGdataset *dataset);
SGdataset*	sg_edit_columns_dialog 		(SGapplication *app,
						 SGdataset *dataset);
SGdataset*	sg_new_dataset_matrix_dialog	(SGpluginDataset *plugin,
						 SGapplication *app);
SGdataset*	sg_edit_dataset_matrix_dialog	(SGpluginDataset *plugin, 
						 SGapplication *app,
                                                 SGdataset *dataset);
SGdataset*	sg_new_dataset_python_dialog	(SGpluginDataset *plugin,
						 SGapplication *app);
SGdataset*	sg_edit_dataset_python_dialog 	(SGpluginDataset *plugin, 
						 SGapplication *app,
                                                 SGdataset *dataset);
SGdataset*	sg_edit_python_dialog 		(SGapplication *app,
						 SGdataset *dataset);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_EDIT_DIALOG_H__ */
