/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_STYLE_FILE_H__
#define __SG_STYLE_FILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtkextra/gtkextra.h>
#include "sg_layer.h"
#include "sg_dataset.h"

typedef struct _SGstyleFile SGstyleFile;

struct _SGstyleFile
{
  gchar *filename;

  GtkPlotData *dataset;

  gboolean in_project;

  FILE *stream;

  void (*write_header) 			(SGstyleFile *file);
  void (*write_footer) 			(SGstyleFile *file);

  void (*save_attributes) 		(SGstyleFile *file);
  void (*save_gradient) 		(SGstyleFile *file);
  void (*save_symbol_style) 		(SGstyleFile *file);
  void (*save_errbars) 			(SGstyleFile *file);
  void (*save_line_style) 		(SGstyleFile *file);
  void (*save_labels_style) 		(SGstyleFile *file);
  void (*save_points) 			(SGstyleFile *file);
};

SGstyleFile* 	sg_style_file_new		(GtkPlotData *dataset, 
						 const gchar *filename);
void    	sg_style_file_export		(SGstyleFile *file,
						 gboolean in_project);
void    	sg_style_file_destroy		(SGstyleFile *file);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_STYLE_FILE_H__ */
