/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_object_file_xml.h"
#include "pixmaps/sg_small.xpm"

static void 		init_default		(SGpluginFile *plugin);
static gboolean 	xml_export_default 	(SGpluginFile *plugin, 
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data);

void
sg_dataset_file_xml_export_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  init_default(plugin);
}

gboolean 	
sg_dataset_file_xml_export			(SGpluginFile *plugin,
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data)
{
  return xml_export_default(plugin, filename, opened, object, data);
}

void
sg_dataset_worksheet_xml_export_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  init_default(plugin);
}

gboolean 	
sg_dataset_worksheet_xml_export			(SGpluginFile *plugin,
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data)
{
  return xml_export_default(plugin, filename, opened, object, data);
}

void
sg_dataset_matrix_xml_export_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean 	
sg_dataset_matrix_xml_export			(SGpluginFile *plugin,
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data)
{
  return xml_export_default(plugin, filename, opened, object, data);
}

void
sg_dataset_function_xml_export_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean 	
sg_dataset_function_xml_export			(SGpluginFile *plugin,
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data)
{
  return xml_export_default(plugin, filename, opened, object, data);
}

void
sg_dataset_python_xml_export_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean 	
sg_dataset_python_xml_export			(SGpluginFile *plugin,
                            			 const gchar *filename,
			    			 FILE *opened,
                            			 GObject **object, 
						 gpointer data)
{
  return xml_export_default(plugin, filename, opened, object, data);
}

static void
init_default(SGpluginFile *plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".sgd");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
xml_export_default 	    (SGpluginFile *plugin, 
                             const gchar *filename,
		             FILE *opened,
                             GObject **object, gpointer data)
{  
  FILE *stream;
  SGdataset *dataset;

  dataset = SG_DATASET(*object);

  if(opened)
    stream = opened;
  else
    stream = sg_file_open(filename, "wb");
    
  if (!stream){
       g_warning( _("ERROR: Cannot write to file: %s"), filename);
       return FALSE;
  } 

  sg_object_file_export_xml(stream, G_OBJECT(dataset), 4);

  if(!opened) sg_file_close(stream);

  return TRUE;
}
