/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_IMPORT_DIALOG_H__
#define __SG_IMPORT_DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_worksheet.h"
#include "sg_plugin_file.h"

typedef enum
{
  SG_DELIMITER_UNKNOWN,
  SG_DELIMITER_COMMA,
  SG_DELIMITER_TAB,
  SG_DELIMITER_SPACE

} SGdelimiter;

gboolean sg_import_dialog 			(const gchar *full_path,
                       				 SGworksheet *worksheet);
gboolean sg_dataset_import_dialog 		(const gchar *full_path,
                       				 SGdataset *dataset);
gboolean sg_edit_file_dialog			(SGdataset *dataset,
						 const gchar * layer_type,
						 GtkPlotArrayList *arrays);
gboolean sg_array_import_dialog 		(const gchar *full_path,
                       				 GtkPlotArray *array);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_IMPORT_DIALOG_H__ */
