/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_dialog.h>

static gint 
add_row(GtkWidget *widget,
        gint row, gint col, gint *new_row, gint *new_col,
        gpointer data)
{
  GtkSheet *sheet = GTK_SHEET(widget);

  if(row == *new_row){
    gtk_sheet_add_row(sheet, 1);
    *new_row = *new_row + 1;
  }
  return TRUE;
}

static gboolean
edit_array(GtkPlotArray *array)
{
  GtkWidget *sw;
  GtkWidget *sheet;
  SGdialog *dialog;
  SGdialogButton rvalue;
  gint i = 0;
  gchar **data = NULL;

  dialog = SG_DIALOG(sg_dialog_new( _( "Edit data" ), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_END));

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_set_border_width(GTK_CONTAINER(sw), 5);
  gtk_widget_set_usize(sw, 200, 200);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(dialog->box),sw,TRUE,TRUE,0);
  sheet = gtk_sheet_new(20, 1, "");
  gtk_container_add(GTK_CONTAINER(sw), sheet);
  gtk_widget_ref(sheet);
  gtk_widget_show_all(dialog->box);

  gtk_sheet_column_button_add_label(GTK_SHEET(sheet), 0, _("Data") );
  gtk_signal_connect(GTK_OBJECT(GTK_SHEET(sheet)), "traverse",
                     GTK_SIGNAL_FUNC(add_row), NULL);
  gtk_widget_show_all(dialog->box);

  rvalue = sg_dialog_run(GTK_WIDGET(dialog), GTK_OBJECT(array));

  if(rvalue == SG_BUTTON_CANCEL) {
    gtk_widget_unref(sheet);
    return FALSE;
  } 

  data = g_new(gchar *, GTK_SHEET(sheet)->maxallocrow+1);
  for(i = 0; i <= GTK_SHEET(sheet)->maxallocrow; i++){
    gchar *text = gtk_sheet_cell_get_text(GTK_SHEET(sheet), i, 0);
    if(text) 
      data[i] = g_strdup(text);
    else 
      data[i] = NULL;
  }
  array->data.data_string = data;
  array->size = GTK_SHEET(sheet)->maxallocrow+1;
  
  gtk_widget_destroy(sheet);
  return TRUE; 
}

GtkPlotArray*
sg_array_edit(SGpluginArray *plugin, SGapplication *app, gpointer _data)
{
  GtkPlotArray *array;
  gboolean rvalue;

  array = GTK_PLOT_ARRAY(g_object_new(gtk_plot_array_get_type(), NULL));
  array->own_data = TRUE;
  array->type = GTK_TYPE_STRING;

  rvalue = edit_array(array);
  if(!rvalue) {
    if(array) g_object_unref(G_OBJECT(array));
    array = NULL;
  }
  return array;
}

