/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_plugin_menu.h"

void
sg_worksheet_menu_show(GtkWidget *widget, GdkEventButton *event)
{
  SGworksheet *worksheet;
  GdkModifierType mods;

  worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(widget), "worksheet"));

  gdk_window_get_pointer(widget->window, NULL, NULL, &mods);
  if(!(mods & GDK_BUTTON3_MASK)) return;

  gtk_menu_popup(GTK_MENU(widget), NULL, NULL, NULL, NULL,
                 event->button, event->time);
}

GtkWidget *
sg_worksheet_menu_new(SGworksheet *worksheet)
{
  GtkWidget *menu;
  SGpluginMenu *plugin;
  GList *list; 
  
  menu = gtk_menu_new();
  g_object_set_data(G_OBJECT(menu), "worksheet", worksheet);

  list = sg_plugins();
  while(list){
    SGplugin *plugin = SG_PLUGIN(list->data);
    if(GTK_IS_SG_PLUGIN_MENU(plugin))
      if(strcmp(SG_PLUGIN_MENU(plugin)->owner_id, "SGworksheet:popup") == 0)
        sg_menu_add_plugin(menu, SG_PLUGIN_MENU(plugin));

    list = list->next;
  }

  return menu;

}

