/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkframe.h>
#include "sg_toolbox.h"
#include "sg.h"
#include "sg_toolbox_icons.h"
#include "pixmaps/as.xpm"

#define NROWS 4
#define NCOLS 2

static void         sg_toolbox_class_init      (SGtoolboxClass *klass);
static void         sg_toolbox_init            (SGtoolbox      *toolbox);
static void         sg_toolbox_size_allocate   (GtkWidget *widget,
						GtkAllocation *allocation);
static void         select_tool                (GtkWidget *widget, 
                                                gpointer data);

static GtkHandleBoxClass *parent_class = NULL;

static void
sg_toolbox_class_init (SGtoolboxClass * klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  parent_class = (GtkHandleBoxClass *) gtk_type_class (gtk_handle_box_get_type ());
  object_class = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;

/* 
  widget_class->size_allocate = sg_toolbox_size_allocate;
*/
}

static void
select_tool(GtkWidget *widget, gpointer data)
{
  gint row, column;
  GdkGC *xor_gc = NULL, *selected_gc = NULL;
  GdkGCValues values;
  GtkWidget *tool;
  SGtoolbox *toolbox;
  GdkPixmap *pixmap;
 
  toolbox = SG_TOOLBOX(data);

  selected_gc=widget->style->fg_gc[GTK_STATE_SELECTED];

  if (!selected_gc) return;

  tool = toolbox->button[0][0];
  pixmap = GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
  gdk_gc_get_values(selected_gc, &values);
  values.function = GDK_INVERT;
  values.foreground = widget->style->white;
  values.subwindow_mode = GDK_INCLUDE_INFERIORS;
  xor_gc = gdk_gc_new_with_values(pixmap, &values,
     (GdkGCValuesMask)(GDK_GC_FOREGROUND | GDK_GC_FUNCTION | GDK_GC_SUBWINDOW));

  gdk_gc_set_foreground(xor_gc, &widget->style->bg[GTK_STATE_SELECTED]);

  for(row = 0; row < 4; row++){
    for(column = 0; column < NCOLS; column++){
       tool = toolbox->button[row][column];
       if(tool != widget){
          if(GTK_TOGGLE_BUTTON(tool)->active == TRUE)
              gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                                 xor_gc,
                                 TRUE, 2, 2, 28, 28);
          GTK_BUTTON(tool)->button_down=FALSE;
          GTK_TOGGLE_BUTTON(tool)->active=FALSE;
          gtk_widget_set_state(tool, GTK_STATE_NORMAL);
       }else{
          if(GTK_TOGGLE_BUTTON(tool)->active != TRUE)
              gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                                 xor_gc,
                                 TRUE, 2, 2, 28, 28);
          GTK_BUTTON(tool)->button_down=TRUE;
          GTK_TOGGLE_BUTTON(tool)->active=TRUE;
          gtk_widget_set_state(tool, GTK_STATE_ACTIVE);
       }
       if(GTK_TOGGLE_BUTTON(tool)->active == TRUE)
          gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(tool)->child)->pixmap,
                             xor_gc,
                             TRUE, 2, 2, 28, 28);
       gtk_widget_queue_draw(tool);
    }
   }
   gtk_widget_grab_focus(widget);
}

static void
sg_toolbox_init (SGtoolbox *toolbox)
{
  const gchar *tip_text[8][2] = {{ N_("Select"),  N_("Zoom")},
				 { N_("Select point"),  N_("Data Marker")},
				 { N_("Text"),  N_("Line/Arrow")},
				 { N_("Rectangle"),  N_("Ellipse")},
				 { N_("Autoscale"),  N_("Fit page inside window")},
				 { N_("Zoom in on data"),  N_("Zoom out from data")},
		 		 { N_("Scroll up"),  N_("Scroll down")},
				 { N_("Scroll left"),  N_("Scroll right")}, };

  GtkTable *table;
  GtkWidget *widget;
  gint i, j;
  GdkPixmap *tool;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GtkTooltips *tooltips;
  GdkColormap *colormap;

  widget = GTK_WIDGET(toolbox);

  gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(widget), GTK_POS_TOP);
  toolbox->box = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(widget), toolbox->box);
  gtk_widget_show(toolbox->box);

  toolbox->table = gtk_table_new(6, 2, FALSE);

  table = GTK_TABLE(toolbox->table);

  gtk_container_set_border_width(GTK_CONTAINER(widget), 2);
  gtk_box_pack_start(GTK_BOX(toolbox->box), toolbox->table, FALSE, FALSE, 0);

  colormap = gdk_colormap_get_system();

  for(i = 0; i < NROWS; i++){
    for(j = 0; j < NCOLS; j++){

      if(i < 2){
        toolbox->button[i][j] = gtk_toggle_button_new();

        gtk_table_attach (GTK_TABLE(table),
                          toolbox->button[i][j],
                          j, j+1, i, i+1, GTK_SHRINK, GTK_SHRINK, 0, 0);

        gtk_signal_connect (GTK_OBJECT (toolbox->button[i][j]), "toggled",
                            (GtkSignalFunc) select_tool,
                            toolbox);
      }
      if(i > 1 && i < 4){
        toolbox->button[i][j] = gtk_toggle_button_new();

        gtk_table_attach (GTK_TABLE(table),
                          toolbox->button[i][j],
                          j, j+1, i+1, i+2, GTK_SHRINK, GTK_SHRINK, 0, 0);

        gtk_signal_connect (GTK_OBJECT (toolbox->button[i][j]), "toggled",
                            (GtkSignalFunc) select_tool,
                            toolbox);
      }

      gtk_button_set_relief(GTK_BUTTON(toolbox->button[i][j]),
                            GTK_RELIEF_NONE);

      gtk_widget_show(toolbox->button[i][j]);

      tooltips = gtk_tooltips_new();
      gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), 
		           toolbox->button[i][j],
                           tip_text[i][j],
		 	   tip_text[i][j]);
      gtk_tooltips_enable(GTK_TOOLTIPS(tooltips));
      gtk_tooltips_set_delay(GTK_TOOLTIPS(tooltips), 0);

    }
  }

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             arrow);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[0][0]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             zoom);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[0][1]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             target);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[1][0]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             markers_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[1][1]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  gtk_table_attach(table, gtk_hseparator_new(), 0, 2, 2, 3,
                   GTK_FILL, GTK_SHRINK, 5, 5);
/********************************************************************/

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             text);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[2][0]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             linearrow_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[2][1]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             rectangle_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[3][0]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  tool=gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                             ellipse_xpm);
  pixmap = gtk_pixmap_new(tool, mask);
  gtk_container_add(GTK_CONTAINER(toolbox->button[3][1]),pixmap);
  gtk_widget_show(pixmap);
  gdk_pixmap_unref(tool);
  gdk_bitmap_unref(mask);

  gtk_table_attach(table, gtk_hseparator_new(), 0, 2, 5, 6,
                   GTK_FILL, GTK_SHRINK, 5, 5);

  toolbox->layer_toolbox = NULL;
}

guint
sg_toolbox_get_type ()
{
  static guint toolbox_type = 0;

  if (!toolbox_type)
    {
      GtkTypeInfo toolbox_info =
      {
	"SGtoolbox",
	sizeof (SGtoolbox),
	sizeof (SGtoolboxClass),
	(GtkClassInitFunc) sg_toolbox_class_init,
	(GtkObjectInitFunc) sg_toolbox_init,
	NULL,
	NULL,
	(GtkClassInitFunc) NULL,
      };
      toolbox_type = gtk_type_unique (gtk_handle_box_get_type(), &toolbox_info);
    }
  return toolbox_type;
}

GtkWidget *
sg_toolbox_new ()
{
  SGtoolbox *toolbox;

  toolbox = (SGtoolbox *)gtk_type_new (sg_toolbox_get_type ());

  return(GTK_WIDGET(toolbox));
}

static void
sg_toolbox_size_allocate    (GtkWidget *widget, GtkAllocation *allocation)
{
  GtkHandleBox *hb;
  GtkRequisition requisition;
  GtkAllocation child_allocation;
  gint width = 0, height = 0;

  hb = GTK_HANDLE_BOX(widget);
  if(hb->child_detached){
     gtk_widget_size_request(SG_TOOLBOX(widget)->table, &requisition);
     height = child_allocation.height = requisition.height;
     width = child_allocation.width = requisition.width;

     child_allocation.height += 2 * GTK_CONTAINER(widget)->border_width + 1;
     child_allocation.width += 2 * GTK_CONTAINER(widget)->border_width;

     child_allocation.x = GTK_CONTAINER(widget)->border_width;
     child_allocation.y = GTK_CONTAINER(widget)->border_width + 10;
     if (GTK_WIDGET_REALIZED (hb))
       {
         gdk_window_resize (hb->float_window,
                            child_allocation.width,
                            child_allocation.height);
         gdk_window_move_resize (hb->bin_window,
                                 0,
                                 0,
                                 child_allocation.width,
                                 child_allocation.height);
         gdk_window_get_size(widget->window, &width, &height);
       }
      gtk_widget_size_allocate(GTK_BIN(widget)->child, &child_allocation); 

      if(SG_TOOLBOX(widget)->layer_toolbox){
        gtk_widget_size_request(SG_TOOLBOX(widget)->layer_toolbox, &requisition);
        child_allocation.height = requisition.height;
        child_allocation.width = requisition.width;

        child_allocation.height += 2 * GTK_CONTAINER(widget)->border_width + 1;
        child_allocation.width += 2 * GTK_CONTAINER(widget)->border_width;
 
        child_allocation.x = GTK_CONTAINER(widget)->border_width;
        child_allocation.y += GTK_CONTAINER(widget)->border_width;

        width = MAX(width, child_allocation.width);
        if (GTK_WIDGET_REALIZED (hb))
          {
            gdk_window_resize (hb->float_window,
                               width,
                               height);
            gdk_window_move_resize (hb->bin_window,
                                    0,
                                    0,
                                    width,
                                    height);
            gdk_window_get_size(widget->window, &width, &height);
          }
         gtk_widget_size_allocate(GTK_BIN(widget)->child, &child_allocation); 
      }
  } else {
     GTK_WIDGET_CLASS(parent_class)->size_allocate(widget, allocation);
  }
}

void
sg_toolbox_add_layer_toolbox(SGtoolbox *toolbox, GtkWidget *ltoolbox)
{
  if(toolbox->layer_toolbox) 
    gtk_container_remove(GTK_CONTAINER(toolbox->box), toolbox->layer_toolbox);

  if(ltoolbox){
    gtk_box_pack_start(GTK_BOX(toolbox->box), ltoolbox, FALSE, FALSE, 0);
    gtk_widget_show_all(ltoolbox);
  }
    
  toolbox->layer_toolbox = ltoolbox;
}
