/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include "sg_stock.h"
#include "sg.h"
#include "pixmaps/stock_pixmaps.h"

GtkWidget *
sg_pixmap_button (GtkWidget *pixmap, const gchar *text)
{
  GtkWidget *button;
  GtkWidget *bbox1, *bbox2;

  button = gtk_button_new ();
  bbox1 = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(button), bbox1);

  bbox2 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(bbox1), bbox2, TRUE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(bbox2), pixmap, FALSE, FALSE, 0);
  gtk_box_pack_end(GTK_BOX(bbox2), gtk_label_new(text), FALSE, FALSE, 2);

  return button;
}

GtkWidget *
sg_stock_pixmap_widget_new (const gchar *type)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *tpixmap;
  gchar **pixmap_data;

  colormap = gdk_colormap_get_system();

  if(strcmp(type, SG_STOCK_BUTTON_OK) == 0) {
    pixmap_data = stock_button_ok_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_CANCEL) == 0) {
    pixmap_data = stock_button_cancel_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_YES) == 0) {
    pixmap_data = stock_button_yes_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_NO) == 0) {
    pixmap_data = stock_button_no_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_CLOSE) == 0) {
    pixmap_data = stock_button_close_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_APPLY) == 0) {
    pixmap_data = stock_button_apply_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_HELP) == 0) {
    pixmap_data = stock_help_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_NEXT) == 0) {
    pixmap_data = stock_right_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_PREV) == 0) {
    pixmap_data = stock_left_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_UP) == 0) {
    pixmap_data = stock_up_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_DOWN) == 0) {
    pixmap_data = stock_down_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_FONT) == 0) {
    pixmap_data = stock_font_xpm; 
  } else if(strcmp(type, SG_STOCK_PIXMAP_OPEN) == 0) {
    pixmap_data = stock_open_xpm; 
  } else return NULL;


  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 pixmap_data);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);

  return (tpixmap);
}


GtkWidget *
sg_stock_button (const gchar *type)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *tpixmap;
  gchar **pixmap_data;
  gchar *text[] = { N_("OK"),
                    N_("Cancel"),
		    N_("Yes"),
		    N_("No"),
		    N_("Close"),
		    N_("Apply"),
		    N_("Help"),
		    N_("Next"),
		    N_("Prev"),
		    N_("Up"),
		    N_("Down"),
		    N_("Font"),
		    NULL
		  };
  gchar *label;

  colormap = gdk_colormap_get_system();

  if(strcmp(type, SG_STOCK_BUTTON_OK) == 0) {
    label = text[0];
    pixmap_data = stock_button_ok_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_CANCEL) == 0) {
    label = text[1];
    pixmap_data = stock_button_cancel_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_YES) == 0) {
    label = text[2];
    pixmap_data = stock_button_yes_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_NO) == 0) {
    label = text[3];
    pixmap_data = stock_button_no_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_CLOSE) == 0) {
    label = text[4];
    pixmap_data = stock_button_close_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_APPLY) == 0) {
    label = text[5];
    pixmap_data = stock_button_apply_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_HELP) == 0) {
    label = text[6];
    pixmap_data = stock_help_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_NEXT) == 0) {
    label = text[7];
    pixmap_data = stock_right_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_PREV) == 0) {
    label = text[8];
    pixmap_data = stock_left_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_UP) == 0) {
    label = text[9];
    pixmap_data = stock_up_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_DOWN) == 0) {
    label = text[10];
    pixmap_data = stock_down_arrow_xpm; 
  } else if(strcmp(type, SG_STOCK_BUTTON_FONT) == 0) {
    label = text[11];
    pixmap_data = stock_font_xpm; 
  } else return NULL;


  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL,
                                                 pixmap_data);
  tpixmap = gtk_pixmap_new(pixmap, mask);
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);

  return (sg_pixmap_button(tpixmap, (const gchar *)label));
}


