/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_property_dialog.h"

static void sg_property_dialog_class_init	(SGpropertyDialogClass *klass);
static void sg_property_dialog_init		(SGpropertyDialog *d);
static void sg_property_dialog_destroy		(GtkObject *object);

static GtkFrameClass *parent_class = NULL;

GtkType 
sg_property_dialog_get_type(void)
{
  static GtkType sg_property_dialog_type = 0;

  if (!sg_property_dialog_type)
    {
      GtkTypeInfo sg_property_dialog_info =
      {
        "SGpropertyDialog",
        sizeof (SGpropertyDialog),
        sizeof (SGpropertyDialogClass),
        (GtkClassInitFunc) sg_property_dialog_class_init,
        (GtkObjectInitFunc) sg_property_dialog_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      sg_property_dialog_type = gtk_type_unique (gtk_frame_get_type(), &sg_property_dialog_info);
    }

  return sg_property_dialog_type;
}

static void 
sg_property_dialog_init(SGpropertyDialog *d)
{
  gtk_frame_set_shadow_type (GTK_FRAME (d), GTK_SHADOW_NONE);

  d->destroy_data = FALSE;
  d->apply = NULL;
  d->ok = NULL;
  d->cancel = NULL;
  d->apply_button = NULL;
  d->ok_button = NULL;
  d->cancel_button = NULL;
  d->data = NULL;
}

static void 
sg_property_dialog_class_init(SGpropertyDialogClass *klass)
{
  GtkObjectClass *object_class;
  SGpropertyDialogClass *d_class;

  object_class = (GtkObjectClass*) klass;
  d_class = (SGpropertyDialogClass*) klass;

  parent_class = (GtkFrameClass *)gtk_type_class (gtk_frame_get_type ());
  object_class->destroy = sg_property_dialog_destroy;
}

GtkWidget *
sg_property_dialog_new()
{
  return GTK_WIDGET(gtk_type_new(sg_property_dialog_get_type()));
}

void
sg_property_dialog_set_data(SGpropertyDialog *dialog, gpointer data, gboolean destroy)
{
  dialog->data = data;
  dialog->destroy_data = destroy;
}

static void
disconnect_buttons(SGpropertyDialog *dialog)
{
  if(dialog->ok_button)
    gtk_signal_disconnect_by_func(GTK_OBJECT(dialog->ok_button),
				  GTK_SIGNAL_FUNC(sg_property_dialog_ok),
				  dialog);
  if(dialog->apply_button)
    gtk_signal_disconnect_by_func(GTK_OBJECT(dialog->apply_button),
				  GTK_SIGNAL_FUNC(sg_property_dialog_apply),
				  dialog);
  if(dialog->cancel_button)
    gtk_signal_disconnect_by_func(GTK_OBJECT(dialog->cancel_button),
				  GTK_SIGNAL_FUNC(sg_property_dialog_cancel),
				  dialog);
  dialog->ok_button = dialog->apply_button = dialog->cancel_button = NULL;
}

static void
sg_property_dialog_destroy(GtkObject *object)
{
  SGpropertyDialog *dialog = SG_PROPERTY_DIALOG(object);

  disconnect_buttons(dialog);

  dialog->ok = dialog->apply = dialog->cancel = NULL;

  if(dialog->destroy_data && dialog->data) g_free(dialog->data);
  dialog->data = NULL;

  if (GTK_OBJECT_CLASS (parent_class)->destroy)
     (*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

void
sg_property_dialog_ok(SGpropertyDialog *d)
{
  if(d->ok) d->ok(d, d->data);
}

void
sg_property_dialog_apply(SGpropertyDialog *d)
{
  if(d->apply) d->apply(d, d->data);
}

void
sg_property_dialog_cancel(SGpropertyDialog *d)
{
  if(d->cancel) d->cancel(d, d->data);
}

void
sg_property_dialog_set_buttons (SGpropertyDialog *dialog, 
                   		GtkWidget *ok_button,
                   		GtkWidget *apply_button,
                   		GtkWidget *cancel_button)
{
  disconnect_buttons(dialog);
  
  if(ok_button)
    gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
                              GTK_SIGNAL_FUNC(sg_property_dialog_ok),
			      GTK_OBJECT(dialog));

  if(apply_button)
    gtk_signal_connect_object(GTK_OBJECT(apply_button), "clicked",
                              GTK_SIGNAL_FUNC(sg_property_dialog_apply),
			      GTK_OBJECT(dialog));

  if(cancel_button)
    gtk_signal_connect_object(GTK_OBJECT(cancel_button), "clicked",
                              GTK_SIGNAL_FUNC(sg_property_dialog_cancel),
			      GTK_OBJECT(dialog));

  dialog->ok_button = ok_button;
  dialog->apply_button = apply_button;
  dialog->cancel_button = cancel_button;
}
