/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_misc.h"

static char * color_xpm[] = {
"40 20 4 1",
"       c #FFFFFFFFFFFF",
".      c #CCCCCCCCCCCC",
"X      c #616161616161",
"o      c #000000000000",
"                                        ",
" ......................................X",
" .XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .Xoooooooooooooooooooooooooooooooooo .X",
" .X                                   .X",
" ......................................X",
" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"};


void
sg_entry_set_numeric(GtkEntry *entry, gint digits)
{
/* FIXME
  gtk_signal_connect(GTK_OBJECT(entry), "insert_text",
                     GTK_SIGNAL_FUNC(sg_editable_insert_digits),
                     GINT_TO_POINTER(digits));
*/
}

void
sg_entry_cancel_space(GtkEntry *entry)
{
/* FIXME
  gtk_signal_connect(GTK_OBJECT(entry), "insert_text",
                     GTK_SIGNAL_FUNC(sg_editable_insert_text),
                     NULL);
*/
}

void
sg_editable_insert_text     (GtkEditable *editable,
                             const gchar *new_text,
                             gint         new_text_length,
                             gint        *position,
                             gpointer data)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "insert_text");
  if(new_text[0] != ' '){
    if(GTK_IS_ITEM_ENTRY(editable))
     GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ITEM_ENTRY))->insert_text(editable,
                                                          new_text,
                                                          new_text_length,
                                                          position);
    else
     GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ENTRY))->insert_text(editable,
                                                          new_text,
                                                          new_text_length,
                                                          position);


  }
}

void
sg_editable_insert_digits   (GtkEditable *editable,
                             const gchar *new_text,
                             guint        new_text_length,
                             gint        *position,
                             gpointer data)
{
  GtkEntry *entry;
  gint digits;
  struct lconv *lc;
  gint sign;
  gint pow10;
  gint dotpos = -1;
  gint powpos = -1;
  guint i;
  GdkWChar pos_sign;
  GdkWChar neg_sign;
  guint entry_length;

  g_return_if_fail (editable != NULL);
  g_return_if_fail (GTK_IS_ENTRY (editable));

  entry = GTK_ENTRY (editable);
  digits  = GPOINTER_TO_INT(data);
  entry_length = entry->text_length;

  lc = localeconv ();

  gtk_signal_emit_stop_by_name(GTK_OBJECT(entry), "insert_text");

  if (*(lc->negative_sign))
    neg_sign = *(lc->negative_sign);
  else
    neg_sign = '-';

  if (*(lc->positive_sign))
    pos_sign = *(lc->positive_sign);
  else
    pos_sign = '+';

  for (pow10 = 0, sign=0, i=0; i<entry_length; i++)
    if ((entry->text[i] == neg_sign) ||
        (entry->text[i] == pos_sign))
      {
        sign++;
      }
    else if((entry->text[i] == 'E') || (entry->text[i] == 'e'))
      {
	pow10++;
	powpos = i;
      }

  if (sign != 0 && !(*position))
    return;

  for (dotpos=-1, i=0; i<entry_length; i++)
    if (entry->text[i] == (GdkWChar)*lc->decimal_point)
      {
        dotpos = i;
        break;
      }

  if ((dotpos > -1 && *position > dotpos) && 
      (powpos > -1 && *position < powpos) &&
      (gint)(digits - entry_length + dotpos - new_text_length + 1) < 0)
    return;

  for (i = 0; i < new_text_length; i++)
    {
      if ((GdkWChar)new_text[i] == neg_sign || (GdkWChar)new_text[i] == pos_sign)
        {
          if (sign || (*position) || i)
             if(pow10 == 0 || (pow10 > 0 && (gint)(i+entry_length) != powpos + 1 && i+entry_length != 0))
                return;
          sign++;
        }
      else if (new_text[i] == *(lc->decimal_point))
        {
          if (!digits || dotpos > -1 ||
              (gint)(new_text_length - 1 - i + entry_length - *position) > digits)
            return;
          dotpos = *position + i;
        }
      else if(new_text[i] == 'E' || new_text[i] == 'e') 
        {
	  if(pow10 || entry_length == 0 || digits == 0) return;
	  pow10++;
        }
      else if (new_text[i] < 0x30 || new_text[i] > 0x39)
	return;
    }

    if(GTK_IS_ITEM_ENTRY(editable))
     GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ITEM_ENTRY))->insert_text(editable,
                                                          new_text,
                                                          new_text_length,
                                                          position);
    else
     GTK_EDITABLE_CLASS (gtk_type_class(GTK_TYPE_ENTRY))->insert_text(editable,
                                                          new_text,
                                                          new_text_length,
                                                          position);

}

void
sg_combo_set_items(GtkCombo *combo, gchar **labels)
{
  GtkWidget *item;
  gchar **text;

  text = labels;
  while(*text){
    item = gtk_list_item_new_with_label(*text);
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(combo->list), item);

    text++;
  }
}

void
sg_color_combo_changed(GtkColorCombo *combo, gint selection, GdkColor *color)
{
  GdkColormap *colormap;
  GdkGC *gc;

  colormap = gdk_colormap_get_system();
  gc = gdk_gc_new(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BUTTON(combo)->button)->child)->pixmap);

  gdk_gc_set_foreground(gc, &combo->selection);

  gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BUTTON(combo)->button)->child)->pixmap,
                     gc,
                     TRUE,
                     4,4,33,13);
  gtk_widget_draw(GTK_BIN(GTK_COMBO_BUTTON(combo)->button)->child, NULL);
  gdk_gc_unref(gc);
}

void
sg_color_combo_init(GtkColorCombo *color_combo, GdkColor new_color)
{
  GdkColormap *colormap;
  GdkGC *gc;
  gint row, col, old_row, old_col;
  GtkWidget *color_pixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  color_combo->selection = new_color;
  
  colormap = gdk_colormap_get_system();
  if(!GTK_BIN(GTK_COMBO_BUTTON(color_combo)->button)->child){
      pixmap=gdk_pixmap_colormap_create_from_xpm_d(NULL,
                                                   colormap,
                                                   &mask, NULL,
                                                   color_xpm);
      color_pixmap=gtk_pixmap_new(pixmap, mask);
      gtk_container_add(GTK_CONTAINER(GTK_COMBO_BUTTON(color_combo)->button),
                        color_pixmap);
      gdk_pixmap_unref(pixmap);
      gdk_bitmap_unref(mask);
  } else {
      color_pixmap = GTK_BIN(GTK_COMBO_BUTTON(color_combo)->button)->child;
  }

  gc = gdk_gc_new(GTK_PIXMAP(color_pixmap)->pixmap);

  gdk_gc_set_foreground(gc, &new_color);
  gdk_draw_rectangle(GTK_PIXMAP(GTK_BIN(GTK_COMBO_BUTTON(color_combo)->button)->child)->pixmap,
                     gc,
                     TRUE,
                     4,4,33,13);
  gtk_widget_draw(GTK_BIN(GTK_COMBO_BUTTON(color_combo)->button)->child, NULL);


  gtk_color_combo_find_color(GTK_COLOR_COMBO(color_combo),
                            &new_color, &row, &col);

  old_row = GTK_COLOR_COMBO(color_combo)->row;
  old_col = GTK_COLOR_COMBO(color_combo)->column;

  if(old_row != -1 && old_col != -1){
    if(color_combo->button) {
      gint index = old_row*color_combo->ncols+old_col;
      GTK_BUTTON(color_combo->button[index])->button_down=FALSE;
      GTK_TOGGLE_BUTTON(color_combo->button[index])->active=FALSE;
      gtk_widget_set_state(color_combo->button[index], GTK_STATE_NORMAL);
      gtk_widget_queue_draw(color_combo->button[index]);
    }
  }

  if(row != -1 && col != -1){
      gint index = row*color_combo->ncols+col;
      GTK_COLOR_COMBO(color_combo)->row = row;
      GTK_COLOR_COMBO(color_combo)->column = col;

      if(color_combo->button) {
        GTK_BUTTON(color_combo->button[index])->button_down=TRUE;
        GTK_TOGGLE_BUTTON(color_combo->button[index])->active=TRUE;
        gtk_widget_set_state(color_combo->button[index], GTK_STATE_ACTIVE);
        gtk_widget_queue_draw(color_combo->button[index]);
      }
  }


  gtk_signal_connect (GTK_OBJECT (color_combo), "changed",
                      GTK_SIGNAL_FUNC (sg_color_combo_changed), NULL);


  gdk_gc_unref(gc);
}
