/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <string.h>
#include "sg.h"

GtkWidget *
sg_matrix_toolbar_new(SGworksheetWindow *window)
{
  GtkWidget *tb;
  SGpluginMenu *plugin;
  GList *list;

  tb = gtk_toolbar_new();
  gtk_toolbar_set_orientation(GTK_TOOLBAR(tb), GTK_ORIENTATION_HORIZONTAL);
  gtk_container_set_border_width(GTK_CONTAINER(tb), 2);

  g_object_set_data(G_OBJECT(tb), "worksheet", window);

  list = sg_plugins();
  while(list){
    SGplugin *plugin = SG_PLUGIN(list->data);
    if(GTK_IS_SG_PLUGIN_MENU(plugin))
      if(strcmp(SG_PLUGIN_MENU(plugin)->owner_id, "SGmatrix:toolbar") == 0)
        sg_toolbar_add_plugin(tb, SG_PLUGIN_MENU(plugin));

    list = list->next;
  }

  return tb;
}

