/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>

static gboolean
main_quit(SGplotWindow *window, SGapplication *app)
{
  sg_application_remove_plot(app, window->plot);
  gtk_main_quit();
  return FALSE;
}

int 
main(int argc, char *argv[])
{
  SGplot *plot;
  SGplotWindow *window;
  SGapplication *app;
  SGpluginLayer *plugin;

  gtk_init(&argc, &argv);
  sg_init("testplot");

  app = SG_APPLICATION(sg_application_new());
  plugin = sg_plugin_layer_get("layer_2d");
  plot = sg_plot_new_with_layer(plugin, _("SciGraphica: Test"));
  sg_application_add_plot(app, plot);

  window = sg_plot_window_new(plot);

  gtk_widget_show_all(GTK_WIDGET(window));

  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(main_quit), app);

  gtk_main();
  sg_quit();
  g_object_unref(G_OBJECT(app));

  return 0;
}

