/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_style.h"
#include "sg_dataset.h"

static void sg_plugin_style_class_init             (SGpluginStyleClass *klass);
static void sg_plugin_style_init                   (SGpluginStyle *plugin);
static void sg_plugin_style_finalize                (GObject *object);
static SGpluginClass *parent_class = NULL;

GType
sg_plugin_style_get_type (void)
{
  static GType sg_plugin_style_type = 0;
                                                                                
  if (!sg_plugin_style_type)
    {
      static const GTypeInfo sg_plugin_style_info =
      {
        sizeof (SGpluginStyleClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_style_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginStyle),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_style_init,
        NULL,
      };
                                                                                
      sg_plugin_style_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginStyle",
                                               &sg_plugin_style_info, 0);
    }
                                                                                
  return sg_plugin_style_type;
}

static void
sg_plugin_style_class_init (SGpluginStyleClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;

  object_class->finalize = sg_plugin_style_finalize;
}


SGpluginStyle *
sg_plugin_style_new ()
{
  SGpluginStyle *plugin;
  plugin = SG_PLUGIN_STYLE(g_object_new(sg_plugin_style_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_style_init(SGpluginStyle *plugin)
{
  plugin->layer = NULL;
  plugin->construct = NULL;
  plugin->property_dialog = NULL;
  plugin->arrays = GTK_PLOT_ARRAY_LIST(gtk_plot_array_list_new());
}

static void
sg_plugin_style_finalize(GObject *object)
{
  SGpluginStyle *plugin = SG_PLUGIN_STYLE(object);

  if(plugin->pixmap && GTK_IS_WIDGET(plugin->pixmap)) 
    gtk_widget_destroy(GTK_WIDGET(plugin->pixmap));
  plugin->pixmap = NULL;

  g_object_unref(G_OBJECT(plugin->arrays));
  plugin->arrays = NULL;

  G_OBJECT_CLASS(parent_class)->finalize(object);
}

GtkPlotData *
sg_plugin_style_construct(SGpluginStyle *plugin)
{
  return plugin->construct();
}

GtkWidget *
sg_plugin_style_dialog(SGpluginStyle *plugin, GtkPlotData *dataset)
{ 
  return(plugin->property_dialog(plugin,dataset));
} 

void            
sg_plugin_style_add_dimension   (SGpluginStyle *plugin,
                                 const gchar *name,
                                 const gchar *label,
                                 const gchar *desc,
                                 GtkType value_type,
                                 gboolean required,
                                 gboolean independent)
{
  GtkPlotArray *dim = NULL;
  if(!name) return;
  dim = GTK_PLOT_ARRAY(gtk_plot_array_new(name, NULL, 0, value_type, FALSE));
  gtk_plot_array_set_label(dim, label);
  gtk_plot_array_set_description(dim, desc);
  gtk_plot_array_set_required(dim, required);
  gtk_plot_array_set_independent(dim, independent);
  gtk_plot_array_list_add(plugin->arrays, dim);
}

gint
sg_plugin_style_num_required_dimensions(SGpluginStyle *plugin)
{
  gint n = 0;
  GList *list = plugin->arrays->arrays; 
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(array->required) n++;
    list = list->next;
  }
  return n;
}

gint
sg_plugin_style_num_independent_dimensions(SGpluginStyle *plugin)
{
  gint n = 0;
  GList *list = plugin->arrays->arrays; 
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(array->independent) n++;
    list = list->next;
  }
  return n;
}

gint
sg_plugin_style_num_dependent_dimensions(SGpluginStyle *plugin)
{
  gint n = 0;
  GList *list = plugin->arrays->arrays; 
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(!array->independent) n++;
    list = list->next;
  }
  return n;
}

gint
sg_plugin_style_min_independent_dimensions(SGpluginStyle *plugin)
{
  gint n = 0;
  GList *list = plugin->arrays->arrays; 
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(array->independent && array->required) n++;
    list = list->next;
  }
  return n;
}

gint
sg_plugin_style_min_dependent_dimensions(SGpluginStyle *plugin)
{
  gint n = 0;
  GList *list = plugin->arrays->arrays; 
  while(list){
    GtkPlotArray *array = GTK_PLOT_ARRAY(list->data);
    if(!array->independent && array->required) n++;
    list = list->next;
  }
  return n;
}

SGpluginStyle *
sg_plugin_style_get(const gchar *name)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_STYLE(list->data)){
      SGpluginStyle *c = SG_PLUGIN_STYLE(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0) return c;
    }
    list = list->next;
  }
  return NULL;
}

