/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_style.h"
#include "sg_plugin_iterator.h"
#include "sg_dataset.h"

static void sg_plugin_iterator_class_init      (SGpluginIteratorClass *klass);
static void sg_plugin_iterator_init            (SGpluginIterator *plugin);
static void sg_plugin_iterator_finalize         (GObject *object);

static SGpluginClass *parent_class = NULL;

GType
sg_plugin_iterator_get_type (void)
{
  static GType sg_plugin_iterator_type = 0;
                                                                                
  if (!sg_plugin_iterator_type)
    {
      static const GTypeInfo sg_plugin_iterator_info =
      {
        sizeof (SGpluginIteratorClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_iterator_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginIterator),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_iterator_init,
        NULL,
      };
                                                                                
      sg_plugin_iterator_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginIterator",
                                               &sg_plugin_iterator_info, 0);
    }
                                                                                
  return sg_plugin_iterator_type;
}

static void
sg_plugin_iterator_class_init (SGpluginIteratorClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;

  object_class->finalize = sg_plugin_iterator_finalize;
}

SGpluginIterator *
sg_plugin_iterator_new ()
{
  SGpluginIterator *plugin;
  plugin = SG_PLUGIN_ITERATOR(g_object_new(sg_plugin_iterator_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_iterator_init(SGpluginIterator *plugin)
{
  plugin->min_independent_dims = 0;
  plugin->max_independent_dims = -1;
  plugin->min_dependent_dims = 0;
  plugin->max_dependent_dims = -1;
  plugin->style = NULL;
  plugin->pixmap = NULL;

  plugin->new_dataset_dialog = NULL;
  plugin->edit_dataset_dialog = NULL;
}

static void
sg_plugin_iterator_finalize(GObject *object)
{
  SGpluginIterator *plugin;

  plugin = SG_PLUGIN_ITERATOR(object);

  if(plugin->style) g_free(plugin->style);
  plugin->style = NULL;

  if(plugin->pixmap && GTK_IS_WIDGET(plugin->pixmap)) 
    gtk_widget_destroy(GTK_WIDGET(plugin->pixmap));
  plugin->pixmap = NULL;

  plugin->new_dataset_dialog = NULL;
  plugin->edit_dataset_dialog = NULL;
  plugin->edit_datapoints_dialog = NULL;

  G_OBJECT_CLASS(parent_class)->finalize(object);
}

SGdataset *
sg_plugin_iterator_construct(SGpluginIterator *plugin, SGpluginStyle *style)
{
  SGdataset *dataset = NULL;

  if(plugin->construct) dataset = plugin->construct(plugin);
  if(dataset) {
    dataset->plugin = SG_PLUGIN(plugin);
    sg_dataset_construct(dataset, style);
  }
  return dataset;
}

SGdataset *
sg_plugin_iterator_new_dialog(SGpluginIterator *plugin, SGpluginStyle *style, SGapplication *app)
{
  SGdataset *dataset = NULL;

  if(!plugin->new_dataset_dialog) return NULL;

  dataset = plugin->new_dataset_dialog(plugin, style, app);

  if(dataset) dataset->plugin = SG_PLUGIN(plugin);

  return dataset;
}

SGdataset *
sg_plugin_iterator_edit_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  SGdataset *new_dataset = NULL;

  if(!plugin->edit_dataset_dialog) return NULL;

  new_dataset = plugin->edit_dataset_dialog(plugin, dataset, app);

  return new_dataset;
}

void
sg_plugin_iterator_edit_data_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  if(plugin->edit_datapoints_dialog)
    plugin->edit_datapoints_dialog(plugin, dataset, app);
}

SGpluginIterator *
sg_plugin_iterator_get(const gchar *name)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_ITERATOR(list->data)){
      SGpluginIterator *c = SG_PLUGIN_ITERATOR(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0) return c;
    }
    list = list->next;
  }
  return NULL;
}
                                                                                

