/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_file.h"

static void sg_plugin_file_class_init             (SGpluginFileClass *klass);
static void sg_plugin_file_init                   (SGpluginFile *plugin);
static void sg_plugin_file_finalize                (GObject *object);
static SGpluginClass *parent_class = NULL;

GType
sg_plugin_file_get_type (void)
{
  static GType sg_plugin_file_type = 0;
                                                                                
  if (!sg_plugin_file_type)
    {
      static const GTypeInfo sg_plugin_file_info =
      {
        sizeof (SGpluginFileClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_file_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginFile),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_file_init,
        NULL,
      };
                                                                                
      sg_plugin_file_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginFile",
                                               &sg_plugin_file_info, 0);
    }
                                                                                
  return sg_plugin_file_type;
}

static void
sg_plugin_file_class_init (SGpluginFileClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;

  object_class->finalize = sg_plugin_file_finalize;
}


SGpluginFile *
sg_plugin_file_new ()
{
  SGpluginFile *plugin;
  plugin = SG_PLUGIN_FILE(g_object_new(sg_plugin_file_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_file_init(SGpluginFile *plugin)
{
  plugin->action = NULL;
}

static void
sg_plugin_file_finalize(GObject *object)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(object);

  if(plugin->object_name) g_free(plugin->object_name);
  plugin->object_name = NULL;

  if(plugin->pixmap && GTK_IS_WIDGET(plugin->pixmap)) 
    gtk_widget_destroy(GTK_WIDGET(plugin->pixmap));
  plugin->pixmap = NULL;
  G_OBJECT_CLASS(parent_class)->finalize(object);
}

void
sg_plugin_file_set_object(SGpluginFile *plugin, const gchar *object)
{
  if(plugin->object_name) g_free(plugin->object_name);
  plugin->object_name = NULL;
  if(object) plugin->object_name = g_strdup(object);
}

gboolean
sg_plugin_file_action(SGpluginFile *plugin, const gchar *file, FILE *opened,
                      GObject **o, gpointer data)
{ 
  return(plugin->action(plugin,file,opened,o,data));
} 

SGpluginFile *
sg_plugin_file_get(const gchar *name, const gchar *object_name, SGpluginFileMode mode)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_FILE(list->data)){
      SGpluginFile *c = SG_PLUGIN_FILE(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0 && strcmp(c->object_name, object_name) == 0 && c->mode == mode) return c;
    }
    list = list->next;
  }
  return NULL;
}

