/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_plugin_array.h"
#include "sg_dataset.h"

static void sg_plugin_array_class_init             (SGpluginArrayClass *klass);
static void sg_plugin_array_init                   (SGpluginArray *plugin);

static SGpluginClass *parent_class = NULL;

GType
sg_plugin_array_get_type (void)
{
  static GType sg_plugin_array_type = 0;
                                                                                
  if (!sg_plugin_array_type)
    {
      static const GTypeInfo sg_plugin_array_info =
      {
        sizeof (SGpluginArrayClass),
        NULL,           /* base_init */
        NULL,           /* base_finalize */
        (GClassInitFunc) sg_plugin_array_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (SGpluginArray),
        0,              /* n_preallocs */
        (GInstanceInitFunc) sg_plugin_array_init,
        NULL,
      };
                                                                                
      sg_plugin_array_type = g_type_register_static (GTK_TYPE_SG_PLUGIN, "SGpluginArray",
                                               &sg_plugin_array_info, 0);
    }
                                                                                
  return sg_plugin_array_type;
}

static void
sg_plugin_array_class_init (SGpluginArrayClass *klass)
{
  GObjectClass *object_class;
  SGpluginClass *plugin_class;

  parent_class = (SGpluginClass *) g_type_class_peek_parent (klass);

  object_class = (GObjectClass *) klass;
  plugin_class = (SGpluginClass *) klass;
}


SGpluginArray *
sg_plugin_array_new ()
{
  SGpluginArray *plugin;
  plugin = SG_PLUGIN_ARRAY(g_object_new(sg_plugin_array_get_type(), NULL));
  return plugin;
}

static void
sg_plugin_array_init(SGpluginArray *plugin)
{
  plugin->action = NULL;
}

GtkPlotArray *
sg_plugin_array_action(SGpluginArray *plugin, SGapplication *app, gpointer data)
{
  if(!plugin->action) return NULL;
  return (plugin->action(plugin, app, data));
}

SGpluginArray *
sg_plugin_array_get(const gchar *name)
{
  GList *list = sg_plugins();
  while(list){
    if(GTK_IS_SG_PLUGIN_ARRAY(list->data)){
      SGpluginArray *c = SG_PLUGIN_ARRAY(list->data);
      if(strcmp(SG_PLUGIN(c)->name, name) == 0) return c;
    }
    list = list->next;
  }
  return NULL;
}

