/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "config.h"
#include "sg_features.h"

const guint sg_major_version = SG_MAJOR_VERSION;
const guint sg_minor_version = SG_MINOR_VERSION;
const guint sg_micro_version = SG_MICRO_VERSION;
const guint sg_binary_age = SG_BINARY_AGE;
const guint sg_interface_age = SG_INTERFACE_AGE;
const gchar* sg_prefix = SG_PREFIX;
const gchar* sg_datadir = SG_DATADIR;
const gchar* sg_libdir = SG_LIBDIR;
const gchar* sg_plugindir = SG_PLUGINDIR;

gchar *
sg_check_version (guint required_major,
                  guint required_minor,
                  guint required_micro)
{
  if (required_major > SG_MAJOR_VERSION)
    return "SciGraphica version too old (major mismatch)";
  if (required_major < SG_MAJOR_VERSION)
    return "SciGraphica version too new (major mismatch)";
  if (required_minor > SG_MINOR_VERSION)
    return "SciGraphica version too old (minor mismatch)";
  if (required_minor < SG_MINOR_VERSION)
    return "SciGraphica version too new (minor mismatch)";
  if (required_micro < SG_MICRO_VERSION - SG_BINARY_AGE)
    return "SciGraphica version too new (micro mismatch)";
  if (required_micro > SG_MICRO_VERSION)
    return "SciGraphica version too old (micro mismatch)";
  return NULL;
}


