/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_python.h"
#include "sg_misc_dialogs.h"
#include "sg_application.h"
#include "sg_plot_menu.h"
#include "sg_matrix_menu.h"
#include "sg_worksheet_menu.h"

GdkPixmap *icon_pixmap;
GdkBitmap *icon_mask;
GRand *sg_seed;

static gboolean _plugins_default = FALSE;
static gint _sg_ref_count;

static void
sg_plugins_default()
{
  if(_plugins_default) return;
  _plugins_default = TRUE;

  sg_plugins_init();
  sg_plugin_install();
}
 
void
sg_init(const gchar *progname)
{ 
 GtkType type;

 _sg_ref_count++;
 sg_python_init(progname);
 sg_python_config_init();
 sg_config_exec_commit_all();
 sg_plugins_default();
 sg_seed = g_rand_new();

 /* We need to regiter all the types before we use gtk_type_from_name  */
 type = sg_plot_get_type(); 
 type = sg_worksheet_get_type(); 
 type = sg_matrix_get_type(); 
 type = gtk_plot_canvas_plot_get_type();
 type = gtk_plot_canvas_pixmap_get_type();
 type = gtk_plot_canvas_rectangle_get_type();
 type = gtk_plot_canvas_ellipse_get_type();
 type = gtk_plot_canvas_line_get_type();
 type = gtk_plot_canvas_text_get_type();
 type = gtk_plot_array_get_type();
}

void
sg_quit()
{
  _sg_ref_count--;
  if(_sg_ref_count == 0) sg_plugins_quit();
  g_rand_free(sg_seed);
}

