/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include "sg_stock.h"
#include "sg_xy_formula_dialog.h"
#include "sg.h"

typedef struct
{
  GtkWidget *name_entry;
  GtkWidget *from_row_spin;
  GtkWidget *to_row_spin;
  GtkWidget *from_col_spin;
  GtkWidget *to_col_spin;
  GtkSheet  *sheet;
} SGformulaDialog;

static void
update_worksheet(SGpropertyDialog *pdialog, gpointer data)
{
  SGformulaDialog *dialog = (SGformulaDialog *)data;
  SGworksheet *worksheet;
  SGmatrix *matrix;
  const gchar *text;
  gint from_row, to_row;
  gint from_col, to_col;
  
  worksheet = SG_WORKSHEET(dialog->sheet);
  matrix = SG_MATRIX(dialog->sheet);

  text = gtk_entry_get_text(GTK_ENTRY(dialog->name_entry));

  if(matrix->format.exp)
    g_free(matrix->format.exp);

  matrix->format.exp=g_strdup(text);

  from_row = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->from_row_spin));
  to_row = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->to_row_spin));
  from_col = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->from_col_spin));
  to_col = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->to_col_spin));

  sg_matrix_set_exp(matrix, text);
  sg_worksheet_update_exp_range(worksheet, from_row, to_row, from_col, to_col);
}


void
sg_xy_formula_dialog (SGworksheet *worksheet)
{
  GtkWidget *ref_dialog;
  SGformulaDialog *dialog;
  GtkWindow *window;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adj;

  dialog = g_new0(SGformulaDialog, 1);
  dialog->sheet = GTK_SHEET(worksheet);

  /* Create widgets */
  frame = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, TRUE);

  table = gtk_table_new(4, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  label = gtk_label_new( _("From Row") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxrow, 1., 1., 0.);
  dialog->from_row_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->from_row_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->from_row_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->from_row_spin, 1, 2, 0, 1);

  label = gtk_label_new( _("To Row") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxrow, 1., 1., 0.);
  dialog->to_row_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->to_row_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->to_row_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->to_row_spin, 3, 4, 0, 1);

  label = gtk_label_new( _("From Column") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 1, 2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxcol, 1., 1., 0.);
  dialog->from_col_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->from_col_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->from_col_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->from_col_spin, 1, 2, 1, 2);

  label = gtk_label_new( _("To Column") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 1, 2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxcol, 1., 1., 0.);
  dialog->to_col_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->to_col_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->to_col_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->to_col_spin, 3, 4, 1, 2);

  gtk_table_attach(GTK_TABLE(table), gtk_hseparator_new(), 0, 4, 2, 3,
                   (GtkAttachOptions)0,
                   (GtkAttachOptions)(GTK_FILL|GTK_EXPAND), 0, 0);

  dialog->name_entry = gtk_entry_new();   

  label = gtk_label_new( _("Matrix(x,y)=") );
  gtk_misc_set_alignment(GTK_MISC(label), 0.5, .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 3, 4);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->name_entry, 1, 4, 3, 4);

  /* connect signals */
  SG_PROPERTY_DIALOG(frame)->ok = update_worksheet;

  gtk_signal_connect (GTK_OBJECT (dialog->name_entry), "activate",
                      GTK_SIGNAL_FUNC (update_worksheet),
                      dialog);

  /* initialize */

  if(SG_MATRIX(worksheet)->format.exp)
    gtk_entry_set_text(GTK_ENTRY(dialog->name_entry),SG_MATRIX(worksheet)->format.exp);
  else
    gtk_entry_set_text(GTK_ENTRY(dialog->name_entry), "");

  gtk_editable_select_region(GTK_EDITABLE(dialog->name_entry),0,-1);
  gtk_editable_set_position(GTK_EDITABLE(dialog->name_entry),-1);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->from_row_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->to_row_spin), dialog->sheet->maxrow);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->from_col_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->to_col_spin), dialog->sheet->maxcol);
  gtk_widget_grab_focus(dialog->name_entry);

  ref_dialog = sg_dialog_new( _("SciGraphica: Matrix values"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  window = GTK_WINDOW(ref_dialog);
  gtk_window_set_policy(window, FALSE, FALSE, FALSE);
  gtk_widget_grab_focus(dialog->name_entry);

  gtk_widget_show_all(frame);
  sg_dialog_add(ref_dialog, SG_PROPERTY_DIALOG(frame));
  sg_dialog_run(ref_dialog, GTK_OBJECT(worksheet));
}
