/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_matrix_dialog.h"
#include "sg.h"                       
#include "sg_stock.h"

typedef struct
{
  GtkWidget *rows_entry;
  GtkWidget *cols_entry;
  GtkWidget *xmin_entry;
  GtkWidget *xmax_entry;
  GtkWidget *ymin_entry;
  GtkWidget *ymax_entry;

  SGmatrix *matrix;
} SGmatrixDialog;

static void
update_matrix(SGpropertyDialog *pdialog, gpointer data)
{
  SGmatrixDialog *dialog = (SGmatrixDialog *)data; 
  SGworksheet *matrix;
  gint nrows, ncols, orows, ocols;

  matrix = SG_WORKSHEET(dialog->matrix);

  orows = gtk_sheet_get_rows_count(GTK_SHEET(matrix)) - 1;
  ocols = gtk_sheet_get_columns_count(GTK_SHEET(matrix)) - 1;

  ncols = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->cols_entry));
  nrows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->rows_entry));

  if(nrows != orows) sg_worksheet_add_rows(matrix, nrows - orows + 1);
  if(ncols != ocols) sg_worksheet_add_columns(matrix, ncols - ocols + 1);

  SG_MATRIX(matrix)->xmin = atof(gtk_entry_get_text(GTK_ENTRY(dialog->xmin_entry)));
  SG_MATRIX(matrix)->xmax = atof(gtk_entry_get_text(GTK_ENTRY(dialog->xmax_entry)));
  SG_MATRIX(matrix)->ymin = atof(gtk_entry_get_text(GTK_ENTRY(dialog->ymin_entry)));
  SG_MATRIX(matrix)->ymax = atof(gtk_entry_get_text(GTK_ENTRY(dialog->ymax_entry)));
}

static void
init_dialog(SGmatrixDialog *dialog)
{
  SGworksheet *matrix;
  gchar label[100];

  matrix = SG_WORKSHEET(dialog->matrix);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->rows_entry), 
                            gtk_sheet_get_rows_count(GTK_SHEET(matrix)));
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->cols_entry),
                            gtk_sheet_get_columns_count(GTK_SHEET(matrix)));

  sprintf(label, "%*.*f", 1, 3, SG_MATRIX(matrix)->xmin);
  gtk_entry_set_text(GTK_ENTRY(dialog->xmin_entry), label);
  sprintf(label, "%*.*f", 1, 3, SG_MATRIX(matrix)->xmax);
  gtk_entry_set_text(GTK_ENTRY(dialog->xmax_entry), label);
  sprintf(label, "%*.*f", 1, 3, SG_MATRIX(matrix)->ymin);
  gtk_entry_set_text(GTK_ENTRY(dialog->ymin_entry), label);
  sprintf(label, "%*.*f", 1, 3, SG_MATRIX(matrix)->ymax);
  gtk_entry_set_text(GTK_ENTRY(dialog->ymax_entry), label);

  sg_entry_set_numeric(GTK_ENTRY(dialog->xmin_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(dialog->xmax_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(dialog->ymin_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(dialog->ymax_entry), 3);
}


void
sg_matrix_dialog (SGmatrix *matrix)
{
  GtkWidget *ref_dialog;
  SGmatrixDialog *dialog;
  GtkWindow *window;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkRequisition req;

  dialog = g_new0(SGmatrixDialog, 1);
  dialog->matrix = matrix;

  /* Create widgets */
  frame = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, TRUE);

  table = gtk_table_new(9, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1000000., 1., 0., 0.); 
  dialog->rows_entry = gtk_spin_button_new(adj, 0, 0);   
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 1000000., 1., 0., 0.); 
  dialog->cols_entry = gtk_spin_button_new(adj, 0, 0);   
  dialog->xmin_entry = gtk_entry_new();   
  dialog->xmax_entry = gtk_entry_new();   
  dialog->ymin_entry = gtk_entry_new();   
  dialog->ymax_entry = gtk_entry_new();   
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->rows_entry), TRUE);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->cols_entry), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->rows_entry), 0);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->cols_entry), 0);

  gtk_widget_size_request(dialog->cols_entry, &req);
  gtk_widget_set_usize(dialog->cols_entry, req.width, req.height);
  gtk_widget_set_usize(dialog->rows_entry, req.width, req.height);
  gtk_widget_set_usize(dialog->xmin_entry, req.width, req.height);
  gtk_widget_set_usize(dialog->xmax_entry, req.width, req.height);
  gtk_widget_set_usize(dialog->ymin_entry, req.width, req.height);
  gtk_widget_set_usize(dialog->ymax_entry, req.width, req.height);

/*
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new(""),
                            0, 2, 0, 1);
*/
  label = gtk_label_new( _("Number of rows") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 2, 1, 2);
  label = gtk_label_new( _("Number of columns") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 2, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_hseparator_new(),
                            0, 4, 3, 4);

  label = gtk_label_new( _("Xmin:") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 6, 7);
  label = gtk_label_new( _("Xmax:") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 6, 7);
  label = gtk_label_new( _("Ymin:") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 7, 8);
  label = gtk_label_new( _("Ymax:") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 7, 8);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->rows_entry, 2, 4, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->cols_entry, 2, 4, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->xmin_entry, 1, 2, 6, 7);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->xmax_entry, 3, 4, 6, 7);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->ymin_entry, 1, 2, 7, 8);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->ymax_entry, 3, 4, 7, 8);

  SG_PROPERTY_DIALOG(frame)->ok = update_matrix;
  SG_PROPERTY_DIALOG(frame)->apply = update_matrix;
  ref_dialog = sg_dialog_new( _("SciGraphica: Matrix dimensions"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_APPLY|SG_BUTTON_CANCEL, GTK_BUTTONBOX_SPREAD);
  window = GTK_WINDOW(ref_dialog);
  gtk_window_set_policy(window, FALSE, FALSE, FALSE);
  sg_dialog_add(ref_dialog, SG_PROPERTY_DIALOG(frame));

  /* Show widgets */

  init_dialog(dialog);

  gtk_widget_show_all (GTK_WIDGET(frame));
  sg_dialog_run(ref_dialog, GTK_OBJECT(matrix));
}
