/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include "sg_formula_dialog.h"
#include "sg.h"
#include "sg_dialog.h"

typedef struct
{
  GtkWidget *name_entry;
  GtkWidget *from_spin;
  GtkWidget *to_spin;
  GtkWidget *attach_item;
  gint column;
  GtkSheet *sheet;
} SGformulaDialog;

static void
update_worksheet(SGpropertyDialog *pdialog, gpointer data)
{
  SGformulaDialog *dialog = (SGformulaDialog *)data;
  const gchar *text;
  gint from, to;
  gboolean attach;

  text = gtk_entry_get_text(GTK_ENTRY(dialog->name_entry));
  from = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->from_spin));
  to = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->to_spin));

  sg_worksheet_update_column_exp(SG_WORKSHEET(dialog->sheet),text,dialog->column,from,to);

  attach = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->attach_item));
  if(attach)
    sg_worksheet_column_set_exp(SG_WORKSHEET(dialog->sheet), dialog->column, text);
}


void
sg_formula_dialog (SGworksheet *worksheet, gint col)
{
  GtkWidget *ref_dialog;
  SGformulaDialog *dialog;
  GtkWindow *window;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label;
  GtkSheetColumn *column;
  GtkAdjustment *adj;
  gchar text[100];
  SGapplication *app = NULL;

  dialog = g_new0(SGformulaDialog, 1);
  dialog->column = col;
  dialog->sheet = GTK_SHEET(worksheet);
  column = &(GTK_SHEET(worksheet)->column[col]);

  app = SG_APPLICATION(g_object_get_data(G_OBJECT(worksheet), "application"));
  if(app) sg_application_set_active_worksheet(app, worksheet);

  /* Create widgets */
  frame = sg_property_dialog_new();
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(frame), dialog, TRUE);

  table = gtk_table_new(2, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  label = gtk_label_new( _("From Row") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxrow, 1., 1., 0.);
  dialog->from_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->from_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->from_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->from_spin, 1, 2, 0, 1);

  label = gtk_label_new( _("To Row") ),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., dialog->sheet->maxrow, 1., 1., 0.);
  dialog->to_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->to_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->to_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->to_spin, 3, 4, 0, 1);

  if(column->name)
    sprintf(text, _("col(\"%s\")=") ,column->name);
  else
    sprintf(text, _("col(%d)=") ,col);

  dialog->name_entry = gtk_entry_new();   

  label = gtk_label_new(text),
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->name_entry, 1, 4, 1, 2);

  dialog->attach_item = gtk_check_item_new_with_label(_("Attach to column"));
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->attach_item, 0, 4, 2, 3);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(dialog->attach_item), TRUE);

  /* Action Area */
  SG_PROPERTY_DIALOG(frame)->ok = update_worksheet;
  SG_PROPERTY_DIALOG(frame)->apply = update_worksheet;
  ref_dialog = sg_dialog_new( _("SciGraphica: Column values"), GTK_ORIENTATION_VERTICAL, SG_BUTTON_OK|SG_BUTTON_APPLY|SG_BUTTON_CLOSE, GTK_BUTTONBOX_SPREAD);
  window = GTK_WINDOW(ref_dialog);

  /* connect signals */
  gtk_signal_connect (GTK_OBJECT (dialog->name_entry), "activate",
                      GTK_SIGNAL_FUNC (update_worksheet),
                      dialog);

  /* initialize */

  if(worksheet->column[col].exp)
    sprintf(text,"%s",worksheet->column[col].exp);
  else
    sprintf(text,"%s", "");

  gtk_entry_set_text(GTK_ENTRY(dialog->name_entry), text);
  gtk_editable_select_region(GTK_EDITABLE(dialog->name_entry),0,-1);
  gtk_editable_set_position(GTK_EDITABLE(dialog->name_entry),-1);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->from_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->to_spin), dialog->sheet->maxrow);
 
  sg_dialog_add(ref_dialog, SG_PROPERTY_DIALOG(frame));
  gtk_window_set_policy(window, FALSE, FALSE, FALSE);
  gtk_widget_grab_focus(dialog->name_entry);
  gtk_widget_show_all(frame); 
  sg_dialog_run (ref_dialog, GTK_OBJECT(worksheet));
}
