/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_property_dialog.h"

typedef struct
{
  GtkWidget *err_width_spin;
  GtkWidget *err_caps_spin;
  GtkWidget *xerr_check;
  GtkWidget *yerr_check;
  GtkWidget *zerr_check;
  gboolean use_x;
  gboolean use_y;
  gboolean use_z;
  GtkPlotData *dataset;
} SGerrbarsDialog;

static void sg_errbars_dialog_apply            (SGpropertyDialog *d, gpointer data);
static void sg_errbars_dialog_ok               (SGpropertyDialog *d, gpointer data);
static void sg_errbars_dialog_init_gui         (GtkWidget *frame);

GtkWidget *
sg_errbars_dialog_new(GtkPlotData *dataset, gboolean use_x, gboolean use_y, gboolean use_z)
{
  GtkWidget *widget;
  SGerrbarsDialog *dialog;

  dialog = g_new0(SGerrbarsDialog, 1);
  widget = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(widget), dialog, TRUE);
  SG_PROPERTY_DIALOG(widget)->apply = sg_errbars_dialog_apply;
  SG_PROPERTY_DIALOG(widget)->ok = sg_errbars_dialog_ok;
  dialog->dataset = dataset;
  dialog->use_x = use_x;
  dialog->use_y = use_y;
  dialog->use_z = use_z;
  sg_errbars_dialog_init_gui(widget);

  return widget;
}

static void
sg_errbars_dialog_ok(SGpropertyDialog *d, gpointer data)
{
  sg_errbars_dialog_apply(d, data);
}

static void     
init_dialog           (SGerrbarsDialog *dialog)
{
  GtkPlotData *data = dialog->dataset;

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->err_width_spin),
                            data->xerrbar_width);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->err_caps_spin),
                            data->xerrbar_caps);
  if(dialog->use_z)
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->zerr_check),
                                  data->show_zerrbars);
  if(dialog->use_x)
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->xerr_check),
                                  data->show_xerrbars);
  if(dialog->use_y)
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->yerr_check),
                                  data->show_yerrbars);
}

static void     
sg_errbars_dialog_init_gui  (GtkWidget *frame)
{
  GtkPlotData *data;
  GtkWidget *label;
  GtkWidget *table;
  GtkRequisition req;
  GtkAdjustment *adj;
  SGerrbarsDialog *dialog = (SGerrbarsDialog *)SG_PROPERTY_DIALOG(frame)->data;

  data = dialog->dataset;
  gtk_frame_set_label(GTK_FRAME(frame), _("Error bars") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);

  if(dialog->use_z)
    table = gtk_table_new(4, 2, FALSE);
  else
    table = gtk_table_new(6, 2, FALSE);

  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add (GTK_CONTAINER (frame), table);

  label = gtk_label_new( _("Width:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);

  label = gtk_label_new( _("Caps:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., 1., 1., 0.);
  dialog->err_width_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->err_width_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->err_width_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table),dialog->err_width_spin,1,2,0,1);

  gtk_widget_size_request(dialog->err_width_spin, &req);
/*  req.width /= 2;
*/

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 20., 1., 1., 0.);
  dialog->err_caps_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->err_caps_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->err_caps_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table),dialog->err_caps_spin,1,2,1,2);

  gtk_widget_set_usize(dialog->err_width_spin, req.width, req.height);
  gtk_widget_set_usize(dialog->err_caps_spin, req.width, req.height);

  if(dialog->use_x){
    dialog->xerr_check = gtk_check_item_new_with_label( _("show xerrbars") );
    gtk_table_attach_defaults(GTK_TABLE(table),dialog->xerr_check,0,3,2,3);
  }
  if(dialog->use_y){
    dialog->yerr_check = gtk_check_item_new_with_label( _("show yerrbars") );
    gtk_table_attach_defaults(GTK_TABLE(table),dialog->yerr_check,0,3,3,4);
  }
  if(dialog->use_z){
    dialog->zerr_check = gtk_check_item_new_with_label( _("show zerrbars") );
    gtk_table_attach_defaults(GTK_TABLE(table),dialog->zerr_check,0,3,2,3);
  }

  init_dialog(dialog);
}

static void
sg_errbars_dialog_apply     (SGpropertyDialog *d, gpointer _data)
{
  SGerrbarsDialog *dialog = (SGerrbarsDialog *)d->data;
  GtkPlotData *data = dialog->dataset;

  if(dialog->use_z)
    data->show_zerrbars = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->zerr_check));
  if(dialog->use_x)
    data->show_xerrbars = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->xerr_check));
  if(dialog->use_y)
    data->show_yerrbars = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->yerr_check));

  data->zerrbar_caps = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_caps_spin));
  data->zerrbar_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_width_spin));

  data->xerrbar_caps = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_caps_spin));
  data->yerrbar_caps = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_caps_spin));

  data->xerrbar_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_width_spin));
  data->yerrbar_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->err_width_spin));
}

