/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_property_dialog.h"
#include "sg.h"

static gchar *project_styles[] = { 
  N_("None"), 
  N_("Empty"), 
  N_("Filled"), 
  NULL 
};

static gchar *line_styles[] = { 
  N_("None"),
  N_("Solid"),
  N_("Dotted"),
  N_("Dashed"),
  N_("Dot-dash"),
  N_("Dot-dot-dash"),
  N_("Dot-dash-dash"),
  NULL
};

typedef struct
{
  GtkPlotData *dataset;
  GtkWidget *grid_check;
  GtkWidget *mesh_check;
  GtkWidget *project_combo;
  GtkWidget *line_color_combo;
  GtkWidget *levels_color_combo;
  GtkWidget *levels_spin;
  GtkWidget *sublevels_color_combo;
  GtkWidget *sublevels_spin;
  GtkWidget *xline_color_combo;
  GtkWidget *transparent_check;
  GtkWidget *lines_check;
  GtkWidget *level_lines_combo;
  GtkWidget *sublevel_lines_combo;
  GtkWidget *height_gradient_check;
  GtkWidget *bg_color_combo;
  GtkWidget *fg_color_combo;
  gboolean is_2d;
} SGcontourDialog;

static void sg_contour_dialog_apply            (SGpropertyDialog *d, gpointer data);
static void sg_contour_dialog_ok               (SGpropertyDialog *d, gpointer data);
static void sg_contour_dialog_init_gui         (GtkWidget *w);

GtkWidget *
sg_contour_dialog_new(GtkPlotData *dataset, gboolean is_2d)
{
  GtkWidget *widget;
  SGcontourDialog *dialog;

  dialog = g_new0(SGcontourDialog, 1);
  widget = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(widget), dialog, TRUE);
  SG_PROPERTY_DIALOG(widget)->apply = sg_contour_dialog_apply;
  SG_PROPERTY_DIALOG(widget)->ok = sg_contour_dialog_ok;
  dialog->dataset = dataset;
  dialog->is_2d = is_2d;
  sg_contour_dialog_init_gui(widget);

  return widget;
}

static void
sg_contour_dialog_ok(SGpropertyDialog *d, gpointer data)
{
  sg_contour_dialog_apply(d, data);
}

static void     
init_dialog (SGcontourDialog *dialog)
{
  GtkPlotSurface *data;

  data = GTK_PLOT_SURFACE(dialog->dataset);

  if(!dialog->is_2d)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->lines_check),
                                 GTK_PLOT_CSURFACE(data)->lines_visible);

  gtk_list_select_item(GTK_LIST(GTK_COMBO(dialog->level_lines_combo)->list), GTK_PLOT_CSURFACE(data)->levels_line.line_style); 
  gtk_list_select_item(GTK_LIST(GTK_COMBO(dialog->sublevel_lines_combo)->list), GTK_PLOT_CSURFACE(data)->sublevels_line.line_style); 
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->levels_spin), GTK_PLOT_CSURFACE(data)->levels_line.line_width);
  sg_color_combo_init(GTK_COLOR_COMBO(dialog->levels_color_combo), GTK_PLOT_CSURFACE(data)->levels_line.color);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->sublevels_spin), GTK_PLOT_CSURFACE(data)->sublevels_line.line_width);
  sg_color_combo_init(GTK_COLOR_COMBO(dialog->sublevels_color_combo), GTK_PLOT_CSURFACE(data)->sublevels_line.color);
  gtk_list_select_item(GTK_LIST(GTK_COMBO(dialog->project_combo)->list), GTK_PLOT_CSURFACE(data)->projection); 

}

static void
sg_contour_dialog_init_gui (GtkWidget *widget)
{
  GtkWidget *main_box, *frame;
  GtkWidget *table, *table1;
  GtkAdjustment *adj;
  SGcontourDialog *dialog;
  GtkRequisition req;
  GtkWidget *label;

  dialog = (SGcontourDialog *)SG_PROPERTY_DIALOG(widget)->data;

  main_box = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);
  gtk_container_add(GTK_CONTAINER(widget), main_box);

  table = gtk_table_new(2, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table), 10);
  gtk_box_pack_start(GTK_BOX(main_box), table, FALSE, FALSE, 0);

  frame = gtk_frame_new( _("Contour") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(table),frame,0,1,0,1);

  table1 = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table1), 5);
  gtk_container_add (GTK_CONTAINER (frame), table1);

  label = gtk_label_new( _("Projection") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,0,1);
  dialog->project_combo = gtk_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table1),dialog->project_combo,1,2,0,1);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(dialog->project_combo)->entry), FALSE);
  sg_combo_set_items(GTK_COMBO(dialog->project_combo), project_styles);
  gtk_widget_size_request(dialog->project_combo, &req);
  req.width /= 2.;
  gtk_widget_set_usize(dialog->project_combo, req.width, req.height);

  if(!dialog->is_2d) {
    dialog->lines_check = gtk_check_item_new_with_label( _("Show lines") );
    gtk_table_attach_defaults(GTK_TABLE(table1),dialog->lines_check,0,2,1,2);
  }

  frame = gtk_frame_new( _("Levels") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(table),frame,1,2,0,1);

  table1 = gtk_table_new(3, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table1), 5);
  gtk_container_add (GTK_CONTAINER (frame), table1);

  label = gtk_label_new( _("Type") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,0,1);
  dialog->level_lines_combo = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(dialog->level_lines_combo)->entry), FALSE);
  sg_combo_set_items(GTK_COMBO(dialog->level_lines_combo), line_styles);
  gtk_table_attach_defaults(GTK_TABLE(table1), dialog->level_lines_combo,1,2,0,1);
  gtk_widget_set_usize(dialog->level_lines_combo, req.width, req.height);

  label = gtk_label_new( _("Width") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,1,2);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., .5, 1., 0.);
  dialog->levels_spin = gtk_spin_button_new(adj, 0.5, 1);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->levels_spin), TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table1),dialog->levels_spin,1,2,1,2);
  gtk_widget_set_usize(dialog->levels_spin, req.width, req.height);

  label = gtk_label_new( _("Color") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,2,3);
  dialog->levels_color_combo = gtk_color_combo_new();
/*
  gtk_widget_set_usize(dialog->levels_color_combo, req.width, req.height);
*/
  gtk_table_attach(GTK_TABLE(table1),dialog->levels_color_combo,1,2,2,3,0,0,0,0);

  frame = gtk_frame_new( _("Sublevels") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(table),frame,2,3,0,1);

  table1 = gtk_table_new(3, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table1), 5);
  gtk_container_add (GTK_CONTAINER (frame), table1);

  label = gtk_label_new( _("Type") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,0,1);
  dialog->sublevel_lines_combo = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(dialog->sublevel_lines_combo)->entry), FALSE);
  sg_combo_set_items(GTK_COMBO(dialog->sublevel_lines_combo), line_styles);
  gtk_table_attach_defaults(GTK_TABLE(table1),dialog->sublevel_lines_combo,1,2,0,1);
  gtk_widget_set_usize(dialog->sublevel_lines_combo, req.width, req.height);
      
  label = gtk_label_new( _("Width") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,1,2);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., .5, 1., 0.);
  dialog->sublevels_spin = gtk_spin_button_new(adj, 0.5, 1);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->sublevels_spin), TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table1),dialog->sublevels_spin,1,2,1,2);
  gtk_widget_set_usize(dialog->sublevels_spin, req.width, req.height);

  label = gtk_label_new( _("Color") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table1),label,0,1,2,3);
  dialog->sublevels_color_combo = gtk_color_combo_new();
/*
  gtk_widget_set_usize(dialog->sublevels_color_combo, req.width, req.height);
*/
  gtk_table_attach(GTK_TABLE(table1),dialog->sublevels_color_combo,1,2,2,3,0,0,0,0);

  init_dialog(dialog);
}

static void     
sg_contour_dialog_apply     (SGpropertyDialog *d, gpointer _data)
{
  SGcontourDialog *dialog = (SGcontourDialog *)d->data;
  GtkPlotSurface *data = GTK_PLOT_SURFACE(dialog->dataset);
  GtkPlotCSurface *contour = GTK_PLOT_CSURFACE(data);
  GtkWidget *child = NULL;

  if(!dialog->is_2d)
    contour->lines_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->lines_check));

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(dialog->project_combo)->list)->selection->data;
  contour->projection = gtk_list_child_position(GTK_LIST(GTK_COMBO(dialog->project_combo)->list), child);
  child = (GtkWidget *)GTK_LIST(GTK_COMBO(dialog->level_lines_combo)->list)->selection->data;
  contour->levels_line.line_style = gtk_list_child_position(GTK_LIST(GTK_COMBO(dialog->level_lines_combo)->list), child);
  child = (GtkWidget *)GTK_LIST(GTK_COMBO(dialog->sublevel_lines_combo)->list)->selection->data;
  contour->sublevels_line.line_style = gtk_list_child_position(GTK_LIST(GTK_COMBO(dialog->sublevel_lines_combo)->list), child);
  contour->levels_line.line_width = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(dialog->levels_spin));
  contour->levels_line.color = gtk_color_combo_get_selection(GTK_COLOR_COMBO(dialog->levels_color_combo));
  contour->sublevels_line.line_width = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(dialog->sublevels_spin));
  contour->sublevels_line.color = gtk_color_combo_get_selection(GTK_COLOR_COMBO(dialog->sublevels_color_combo));
}

