/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_property_dialog.h"

typedef struct
{
  GtkWidget *arrow_combo;
  GtkWidget *arrow_length_spin;
  GtkWidget *arrow_width_spin;
  GtkWidget *arrow_center_check;
  GtkPlotData *dataset;
} SGarrowDialog;

static void sg_arrow_dialog_apply            (SGpropertyDialog *d, 
					      gpointer data);
static void sg_arrow_dialog_ok               (SGpropertyDialog *d, 
					      gpointer data);
static void sg_arrow_dialog_init_gui         (GtkWidget *frame);

static gchar *symbol_styles[] = { N_("Empty"), N_("Filled"), N_("Opaque"), NULL };

GtkWidget *
sg_arrow_dialog_new(GtkPlotData *dataset)
{
  GtkWidget *widget;
  SGarrowDialog *dialog;

  dialog = g_new0(SGarrowDialog, 1);
  dialog->dataset = dataset;

  widget = sg_property_dialog_new();
  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(widget), dialog, TRUE);
  SG_PROPERTY_DIALOG(widget)->apply = sg_arrow_dialog_apply;
  SG_PROPERTY_DIALOG(widget)->ok = sg_arrow_dialog_ok;
  sg_arrow_dialog_init_gui(widget);

  return widget;
}

static void
sg_arrow_dialog_ok(SGpropertyDialog *d, gpointer data)
{
  sg_arrow_dialog_apply(d, data);
}

static void     
init_dialog(SGarrowDialog *dialog)
{
  GtkPlotData *data = dialog->dataset; 

  gtk_list_select_item(GTK_LIST(GTK_COMBO(dialog->arrow_combo)->list),
                       GTK_PLOT_FLUX(data)->arrow_style);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->arrow_length_spin),
                            GTK_PLOT_FLUX(data)->arrow_length);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->arrow_width_spin),
                                GTK_PLOT_FLUX(data)->arrow_width);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dialog->arrow_center_check),
                                   GTK_PLOT_FLUX(data)->centered);
}

static void     
sg_arrow_dialog_init_gui (GtkWidget *frame)
{
  GtkWidget *label;
  GtkWidget *table;
  GtkRequisition req;
  GtkAdjustment *adj;
  SGarrowDialog *dialog = (SGarrowDialog *)SG_PROPERTY_DIALOG(frame)->data;

  gtk_frame_set_label(GTK_FRAME(frame), _("Arrows") );
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);

  table = gtk_table_new(13, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add (GTK_CONTAINER (frame), table);

  label = gtk_label_new( _("Style:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label , 0, 1, 0, 1);
  dialog->arrow_combo = gtk_combo_new();
  sg_combo_set_items(GTK_COMBO(dialog->arrow_combo), symbol_styles);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->arrow_combo, 1, 2, 0, 1);

  label = gtk_label_new( _("Length:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 40., 1., 1., 0.);
  dialog->arrow_length_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->arrow_length_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->arrow_length_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->arrow_length_spin, 1, 2, 1, 2);

  label = gtk_label_new( _("Width:") );
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 40., 1., 1., 0.);
  dialog->arrow_width_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dialog->arrow_width_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(dialog->arrow_width_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->arrow_width_spin, 1, 2, 2, 3);

  dialog->arrow_center_check = gtk_check_item_new_with_label( _("Center") );
  gtk_table_attach_defaults(GTK_TABLE(table), dialog->arrow_center_check, 0, 2, 3, 4);

  gtk_widget_size_request(dialog->arrow_combo, &req);
  gtk_widget_set_usize(dialog->arrow_combo, req.width / 2, req.height);
  gtk_widget_set_usize(dialog->arrow_width_spin, req.width / 2, req.height);
  gtk_widget_set_usize(dialog->arrow_length_spin, req.width / 2, req.height);
  gtk_widget_show_all(table);

  init_dialog(dialog);
}

static void     
sg_arrow_dialog_apply     (SGpropertyDialog *d, gpointer _data)
{
  GtkWidget *child;
  SGarrowDialog *dialog = (SGarrowDialog *)d->data;
  GtkPlotFlux *data = GTK_PLOT_FLUX(dialog->dataset);

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(dialog->arrow_combo)->list)->selection->data;

  data->arrow_style = (GtkPlotSymbolStyle)gtk_list_child_position(GTK_LIST(GTK_COMBO(dialog->arrow_combo)->list), child);
  data->arrow_length = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->arrow_length_spin));
  data->arrow_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->arrow_width_spin));
  data->centered = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dialog->arrow_center_check));
}

