/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_style_dialog.h>
#include "pixmaps/g_vectors.xpm"
#include <sg_data_line_dialog.h>
#include <sg_data_labels_dialog.h>
#include <sg_errbars_dialog.h>
#include <sg_symbol_dialog.h>
#include <sg_line_symbol_dialog.h>
#include <sg_xyz_dialog.h>
#include <sg_arrow_dialog.h>
#include <sg_gradient_dialog.h>
#include <sg_vector_scale_dialog.h>

GtkPlotData *
vectors_2d_construct()
{
  GtkPlotData *data = GTK_PLOT_DATA(gtk_plot_flux_new());
  GTK_PLOT_FLUX(data)->centered = FALSE;
  data->line.line_style = GTK_PLOT_LINE_NONE;
  data->symbol.symbol_style = GTK_PLOT_SYMBOL_NONE;

  return data;
}

void
vectors_2d_init(SGplugin *_plugin)
{
  SGpluginStyle *plugin = SG_PLUGIN_STYLE(_plugin);
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;

  colormap = gdk_colormap_get_system();

  plugin->layer = g_strdup("layer_2d");

  sg_plugin_style_add_dimension(plugin, "x", "X1", "Origin X", GTK_TYPE_DOUBLE, TRUE, TRUE);
  sg_plugin_style_add_dimension(plugin, "y", "Y1", "Origin Y", GTK_TYPE_DOUBLE, TRUE, TRUE);
  sg_plugin_style_add_dimension(plugin, "dx", "X2", "End X", GTK_TYPE_DOUBLE, TRUE, FALSE);
  sg_plugin_style_add_dimension(plugin, "dy", "Y2", "End Y", GTK_TYPE_DOUBLE, TRUE, FALSE);

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, NULL, NULL, g_vectors_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, NULL));
  gdk_pixmap_unref(pixmap);
}

static void
dialog_ok(SGpropertyDialog *pdialog, gpointer data)
{
  gint i;
  SGpropertyDialog **dialogs = (SGpropertyDialog **)data;

  for(i = 0; i < 8; i++)
    sg_property_dialog_apply(dialogs[i]);

};

GtkWidget * 	
vectors_2d_dialog(SGpluginStyle *plugin, GtkPlotData *data)
{
  GtkWidget *notebook;
  GtkWidget **dialogs;
  GtkWidget *the_dialog;
 
  dialogs = g_new0(GtkWidget *, 8);

  the_dialog = sg_property_dialog_new();
  notebook = gtk_notebook_new();
  gtk_container_add(GTK_CONTAINER(the_dialog), notebook);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[0] = sg_arrow_dialog_new(data),
                           gtk_label_new( _("Arrows") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[1] = sg_vector_scale_dialog_new(data),
                           gtk_label_new( _("Scale") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[2] = sg_line_symbol_dialog_new(data, TRUE, TRUE),
                           gtk_label_new( _("Lines+Symbols") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[3] = sg_xyz_dialog_new(data, FALSE),
                           gtk_label_new( _("Aux lines") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[4] = sg_errbars_dialog_new(data, TRUE, TRUE, FALSE),
                           gtk_label_new( _("Error bars") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                           dialogs[5] = sg_data_labels_dialog_new(data, TRUE),
                           gtk_label_new( _("Labels") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[6] = sg_gradient_dialog_new(data, 2),
                           gtk_label_new( _("Levels+Colors") ));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), 
                           dialogs[7] = sg_gradient_labels_dialog_new(data),
                           gtk_label_new( _("Gradient format") ));

  sg_property_dialog_set_data(SG_PROPERTY_DIALOG(the_dialog), dialogs, TRUE);
  SG_PROPERTY_DIALOG(the_dialog)->ok = dialog_ok;
  SG_PROPERTY_DIALOG(the_dialog)->apply = dialog_ok;

  return the_dialog;
}

