/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"
#include "sg_plugin_menu.h"
#include "sg_column_dialog.h"
#include "sg_convert_dialog.h"
#include "sg_matrix_convert.h"
#include "sg_formula_dialog.h"
#include "sg_misc_dialogs.h"
#include "sg_clipboard.h"
#include "sg_file_dialog.h"
#include "sg_append_dialog.h"

void
worksheet_popup_append_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_append_dialog(worksheet, GTK_ORIENTATION_VERTICAL);
}

void
worksheet_popup_append_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_append_dialog(worksheet, GTK_ORIENTATION_HORIZONTAL);
}

void
worksheet_popup_insert_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(worksheet);
  range = sheet->range;

  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return;

  sg_worksheet_insert_rows(worksheet, sheet->range.row0,
                           sheet->range.rowi - sheet->range.row0 + 1);
}

void
worksheet_popup_insert_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED){
    sg_worksheet_insert_columns(worksheet, sheet->range.col0,
                                sheet->range.coli - sheet->range.col0 + 1);
  }
}

void
worksheet_popup_remove_rows(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint nrows;
  
  sheet = GTK_SHEET(worksheet);

  if(sheet->maxrow < 2) return;

  range = sheet->range;
  nrows = range.rowi - range.row0 + 1;

  if(sheet->state != GTK_SHEET_ROW_SELECTED) return;

  sg_worksheet_delete_rows(worksheet, sheet->range.row0, nrows);
}

void
worksheet_popup_remove_cols(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  GtkSheetRange range;
  gint ncols;
  
  sheet = GTK_SHEET(worksheet);

  if(sheet->maxcol < 2) return;

  range = sheet->range;
  ncols = range.coli - range.col0 + 1;

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
    sg_worksheet_delete_columns(worksheet, sheet->range.col0, ncols);
}

void
worksheet_popup_begin(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  sg_worksheet_set_begin(worksheet, sheet->range.row0);
}

void
worksheet_popup_end(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  sg_worksheet_set_end(worksheet, sheet->range.row0);
}

void
worksheet_popup_reset(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_reset(worksheet);
}

void
worksheet_popup_cut(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_copy(worksheet, TRUE);
}

/*
void
worksheet_popup_cut_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, cut_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
*/

void
worksheet_popup_copy(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_copy(worksheet, FALSE);
}

/*
void
worksheet_popup_copy_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, copy_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
*/

void
worksheet_popup_paste(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_paste(worksheet);
}

/*
void
worksheet_popup_paste_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  SGpluginMenu *plugin = SG_PLUGIN_MENU(_plugin);

  colormap = gdk_colormap_get_system();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, paste_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
*/

void
worksheet_popup_clear(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  gtk_sheet_range_clear(sheet, &sheet->range);
}

void
worksheet_popup_clear_all(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);
  gtk_sheet_range_clear(sheet, NULL);
}

void
worksheet_popup_col_properties(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED){
     sg_column_dialog(worksheet, sheet->range.col0);
  }
}

void
worksheet_popup_set_values(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;
  sheet = GTK_SHEET(worksheet);
  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(worksheet, sheet->range.col0);
}
void
worksheet_popup_mask(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GtkSheet *sheet;

  sheet = GTK_SHEET(worksheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(worksheet, sheet->range.col0);
}

void
worksheet_popup_export(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GObject *o = G_OBJECT(worksheet);
  GtkWidget *filesel;
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_EXPORT, NULL, "SGworksheet", o);
  sg_file_dialog_run(filesel);
}

void
worksheet_popup_import(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  GObject *o = G_OBJECT(worksheet);
  GtkWidget *filesel;
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, NULL, "SGworksheet", o);
  sg_file_dialog_run(filesel);
}

void
worksheet_popup_ascii(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
/* FIXME
  sg_import_dialog(NULL,NULL);
*/
}

void
worksheet_popup_convert_xyz(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_convert_dialog(worksheet, TRUE);
}

void
worksheet_popup_convert_columns(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_convert_dialog(worksheet, FALSE);
}

void
worksheet_popup_convert(SGpluginMenu *plugin, GtkWidget *menu, gpointer _data)
{
  SGworksheet *worksheet = SG_WORKSHEET(g_object_get_data(G_OBJECT(menu), "worksheet"));
  sg_worksheet_to_matrix(worksheet);
}

