/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include "sg_edit_dialog.h"

#define DATASET_NAME_LENGTH 100

SGdataset*
sg_dataset_python_new_dialog(SGpluginIterator *plugin, SGpluginStyle *style, SGapplication *app)
{
  SGdataset *dataset = NULL;
  SGdataset *return_data = NULL;
  gchar name[200];

  dataset = sg_plugin_iterator_construct(plugin, style);
  if(dataset){
    g_snprintf(name,200,"Python");
    sg_dataset_set_name(dataset, name);

    return_data = sg_edit_python_dialog(app, dataset);
    if(!return_data)
      g_object_unref(G_OBJECT(dataset));
  }

  return return_data;
}

SGdataset*
sg_dataset_python_edit_dialog(SGpluginIterator *plugin, SGdataset *dataset, SGapplication *app)
{
  SGdataset *return_data = NULL;

  return_data = sg_edit_python_dialog(app, dataset);
  if(!return_data) return_data = dataset;
  return return_data;
}


