/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sg.h>
#include "sg_dataset_worksheet.h"
#include "sg_dataset_matrix.h"
#include "sg_dataset_function.h"
#include "sg_dataset_python.h"
#include "pixmaps/new_small.xpm"
#include "pixmaps/sheet_small.xpm"
#include "pixmaps/python_small.xpm"
#include "pixmaps/function_small.xpm"


void
sg_dataset_file_init(SGplugin *plugin)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GtkType type;

  colormap = gdk_colormap_get_system();

  type = sg_dataset_get_type();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, new_small_xpm);
  SG_PLUGIN_ITERATOR(plugin)->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

SGdataset *
sg_dataset_file_construct(SGpluginIterator *plugin)
{
  SGdataset *dataset = sg_dataset_new();
  return dataset;
}

void
sg_dataset_worksheet_init(SGplugin *plugin)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GtkType type;
                                                                         
  colormap = gdk_colormap_get_system();

  type = sg_dataset_worksheet_get_type();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, sheet_small_xpm);
  SG_PLUGIN_ITERATOR(plugin)->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

SGdataset *
sg_dataset_worksheet_construct(SGpluginIterator *plugin)
{
  SGdataset *dataset = SG_DATASET(sg_dataset_worksheet_new());
  return dataset;
}

void
sg_dataset_matrix_init(SGplugin *plugin)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GtkType type;
                                                                         
  colormap = gdk_colormap_get_system();

  type = sg_dataset_matrix_get_type();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, sheet_small_xpm);
  SG_PLUGIN_ITERATOR(plugin)->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);

  SG_PLUGIN_ITERATOR(plugin)->min_independent_dims = 2; /* x, y */
  SG_PLUGIN_ITERATOR(plugin)->max_independent_dims = 2; /* x, y */
  SG_PLUGIN_ITERATOR(plugin)->min_dependent_dims = 1;
  SG_PLUGIN_ITERATOR(plugin)->max_dependent_dims = 1;
}

SGdataset *
sg_dataset_matrix_construct(SGpluginIterator *plugin)
{
  SGdataset *dataset = SG_DATASET(g_object_new(sg_dataset_matrix_get_type(), NULL));
  return (dataset);
}

void
sg_dataset_function_init(SGplugin *plugin)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GtkType type;
                                                                         
  colormap = gdk_colormap_get_system();

  type = sg_dataset_function_get_type();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, function_small_xpm);
  SG_PLUGIN_ITERATOR(plugin)->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);

  SG_PLUGIN_ITERATOR(plugin)->min_independent_dims = 1; /* x */
  SG_PLUGIN_ITERATOR(plugin)->max_independent_dims = 1; /* x */
  SG_PLUGIN_ITERATOR(plugin)->min_dependent_dims = 1; /* y */
  SG_PLUGIN_ITERATOR(plugin)->max_dependent_dims = 1; /* y */
  SG_PLUGIN_ITERATOR(plugin)->style = g_strdup("lines_2d");
}

SGdataset *
sg_dataset_function_construct(SGpluginIterator *plugin)
{
  SGdataset *dataset = SG_DATASET(g_object_new(sg_dataset_function_get_type(), NULL));
  return dataset;
}

void
sg_dataset_python_init(SGplugin *plugin)
{
  GdkColormap *colormap;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GtkType type;
                                                                         
  colormap = gdk_colormap_get_system();

  type = sg_dataset_python_get_type();
  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask, NULL, python_small_xpm);
  SG_PLUGIN_ITERATOR(plugin)->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
}

SGdataset *
sg_dataset_python_construct(SGpluginIterator *plugin)
{
  SGdataset *dataset = SG_DATASET(g_object_new(sg_dataset_python_get_type(), NULL));
  return dataset;
}

