/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DATASET_FUNCTION_H__
#define __SG_DATASET_FUNCTION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg.h"

#define SG_DATASET_FUNCTION(obj)        GTK_CHECK_CAST (obj, sg_dataset_function_get_type (), SGdatasetFunction)
#define GTK_TYPE_SG_DATASET_FUNCTION   (sg_dataset_function_get_type ())

#define SG_DATASET_FUNCTION_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_dataset_function_get_type(), SGdatasetFunctionClass)
#define GTK_IS_SG_DATASET_FUNCTION(obj)     GTK_CHECK_TYPE (obj, sg_dataset_function_get_type ())

typedef struct _SGdatasetFunction SGdatasetFunction;
typedef struct _SGdatasetFunctionClass SGdatasetFunctionClass;

struct _SGdatasetFunction 
{
  SGdataset dataset;

  gchar *exp;
};

struct _SGdatasetFunctionClass 
{
  SGdatasetClass parent_class;
};

GType		sg_dataset_function_get_type	(void);
SGdataset*	sg_dataset_function_new		(); 
void		sg_dataset_function_set		(SGdatasetFunction *dataset,
						 const gchar *exp);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_DATASET_FUNCTION_H__ */

