/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_import_dialog.h"
#include "pixmaps/sg_small.xpm"

void
SGworksheet_ascii_import_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_IMPORT;
  plugin->nfilters = 2;
  sprintf(plugin->filter[0],".dat");
  sprintf(plugin->filter[1],".csv");
  sprintf(plugin->filter[2],".txt");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

void
SGmatrix_ascii_import_init(SGpluginFile *plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  plugin->mode = SG_PLUGIN_FILE_IMPORT;
  plugin->nfilters = 2;
  sprintf(plugin->filter[0],".dat");
  sprintf(plugin->filter[1],".csv");
  sprintf(plugin->filter[2],".txt");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGworksheet_ascii_import	  (SGpluginFile *plugin, 
			           const gchar *filename, 
			           FILE *stream,
                                   GObject **object, gpointer data)
{  
  return sg_import_dialog(filename, SG_WORKSHEET(*object));
}

gboolean
SGmatrix_ascii_import	  	  (SGpluginFile *plugin, 
			           const gchar *filename, 
			           FILE *stream,
                                   GObject **object, gpointer data)
{  
  return sg_import_dialog(filename, SG_WORKSHEET(*object));
}

