/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include "sg_worksheet_file.h"

SGworksheetfile*
sg_worksheet_file_new (SGworksheet *worksheet, const gchar *filename)
{
  SGworksheetfile *file;

  if(!filename) return NULL;
  if(!worksheet) return NULL;

  file = g_new(SGworksheetfile, 1);
  file->filename = g_strdup(filename); 
  file->worksheet = worksheet;

  file->write_header = NULL;
  file->write_footer = NULL;

  file->write_col_title = NULL;
  file->write_row_title = NULL;

  file->new_row = NULL;
  file->new_column = NULL;

  file->write_cell = NULL;

  file->titlecolor = NULL;
  file->cellcolor = NULL;

  file->stream = NULL;

  return file;
}

void
sg_worksheet_file_export (SGworksheetfile *file, GtkSheetRange *range)
{  
  GtkSheet *sheet;
  GtkSheetRange export_range;
  gint row, col;

  sheet = GTK_SHEET(file->worksheet);

  if(range == NULL){
     export_range.row0 = 0;
     export_range.rowi = sheet->maxallocrow;
     export_range.col0 = 0;
     export_range.coli = sheet->maxalloccol;
  }
  else
     export_range = *range;

  file->range = export_range;
 
  if(file->write_header) file->write_header(file); 

  for(col = export_range.col0; col <= export_range.coli; col++){
     if(col > export_range.col0 && file->new_column) 
         file->new_column(file, col);
     if(file->write_col_title) 
         file->write_col_title(file, col); 
  }

  for(row = export_range.row0; row <= export_range.rowi; row++){
    if(file->new_row)
         file->new_row(file, row);

    if(file->write_row_title) 
         file->write_row_title(file, row); 

    for(col = export_range.col0; col <= export_range.coli; col++){
        if(col > export_range.col0 && file->new_column) 
                                               file->new_column(file, col);
        file->write_cell(file, row, col);       
    }
  }

  if(file->write_footer) file->write_footer(file); 
}

void
sg_worksheet_file_destroy (SGworksheetfile *file)
{  
  if(file->filename) g_free(file->filename);
  if(file->titlecolor) g_free(file->titlecolor);
  if(file->cellcolor) g_free(file->cellcolor);
  g_free(file);
}
