/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_object_file_xml.h"
#include "sg_style_file_xml.h"

static void write_header_xml                    (FILE *file, GtkPlotData *data);
static void write_footer_xml                    (FILE *file, GtkPlotData *data);
static void save_gradient_xml 		        (FILE *file, GtkPlotData *data);
static void save_points_xml               	(FILE *file, GtkPlotData *data);

gboolean
sg_style_file_export_xml (SGpluginFile *plugin,
                          const gchar *filename,
                          FILE *opened,
                          GObject **object, gpointer data)
{
  FILE *file;
  GtkPlotData *dataset;
                                                                                
  dataset = GTK_PLOT_DATA(*object);
                                                                                
  if(opened)
    file = opened;
  else
    file = sg_file_open(filename, "wb");
                                                                                
  if (!file){
       g_warning( _("ERROR: Cannot write to file: %s"), filename);
       return FALSE;
  }
                                                                                
  if(!opened)  sg_file_printf(file,"<?xml version=\"1.0\"?>\n");

  write_header_xml(file, dataset);
  sg_object_file_export_xml(file, G_OBJECT(dataset), 4); 
  save_gradient_xml(file, dataset); 
  save_points_xml(file, dataset); 
  write_footer_xml(file, dataset);
                                                                                
  if(!opened) sg_file_close(file);
                                                                                
  return TRUE;
}

static void
write_header_xml(FILE *file, GtkPlotData *data)
{
  SGdataset *dataset = SG_DATASET(data->link);
  SGpluginStyle *plugin = dataset->constructor;

  sg_file_printf(file,"      <sgp:Style Name=\"%s\" Layer=\"%s\">\n", SG_PLUGIN(plugin)->name, plugin->layer);
}

static void
write_footer_xml(FILE *file, GtkPlotData *data)
{
  sg_file_printf(file,"      </sgp:Style>\n");
}

static void
save_gradient_xml(FILE *file, GtkPlotData *data)
{
  int n = 0;

  sg_file_printf(file, "        <sgp:Gradient>\n");

  for(n = 0; n < data->gradient->ticks.nticks; n++)
    sg_file_printf(file, "          <sgp:Color Level=\"%d\" R=\"%d\" G=\"%d\" B=\"%d\"/>\n", n, data->gradient_colors[n].red, data->gradient_colors[n].green, data->gradient_colors[n].blue);

  sg_file_printf(file, "        </sgp:Gradient>\n");
}

static void
save_points_xml(FILE *file, GtkPlotData *data)
{
  GtkPlotArrayList *dimset = NULL;
  GList *list = NULL;

  dimset = data->data;

  sg_file_printf(file, "        <sgp:Points No=\"%d\">\n", data->num_points);

  list = dimset->arrays;
  while(list){
    GtkPlotArray *dim = GTK_PLOT_ARRAY(list->data);

    sg_object_file_export_xml(file, G_OBJECT(dim), 6);

/*
    if(dim->type == GTK_TYPE_DOUBLE){
      gdouble *array = gtk_plot_array_get_double(dim);
      gint size = gtk_plot_array_get_size(dim);
      gchar *name = dim->name;

      if(array && size > 0){
        gint n = 0;
        sg_file_printf(file, "          <sgp:Dimension Name=\"%s\" Type=\"%i\" Size=\"%d\">\n", name, dim->type, size);
	for(n = 0; n < size; n++){
          sg_file_printf(file, "            <sgp:Point Index=\"%d\" Value=\"%f\"/>\n", n, array[n]);
        }
        sg_file_printf(file, "          </sgp:Dimension>\n");
      } 
    }
    if(dim->type == GTK_TYPE_STRING){
      gchar **array = gtk_plot_array_get_string(dim);
      gint size = gtk_plot_array_get_size(dim);
      gchar *name = dim->name;

      if(array && size > 0){
        gint n = 0;
        sg_file_printf(file, "          <sgp:Dimension Name=\"%s\" Type=\"%i\" Size=\"%d\">\n", name, dim->type, size);
	for(n = 0; n < size; n++){
          sg_file_printf(file, "            <sgp:Point Index=\"%d\" Value=\"%s\"/>\n", n, array[n]);
        }
        sg_file_printf(file, "          </sgp:Dimension>\n");
      } 
    }
*/
    list = list->next;
  }

  sg_file_printf(file, "        </sgp:Points>\n");
}

