/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "config.h"
#include "pixmaps/sg_small.xpm"

static gboolean
default_save(const gchar *filename, GObject **object);

void
SGplot_jpeg_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".jpeg");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGplot_jpeg_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
SGplot_png_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".png");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGplot_png_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
SGplot_xpm_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".xpm");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGplot_xpm_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
SGplot_tiff_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".tiff");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGplot_tiff_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
SGplot_bmp_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".bmp");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
SGplot_bmp_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
SGplot_gif_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".gif");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
gboolean
SGplot_gif_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

static gboolean
default_save(const gchar *filename, GObject **object)
{
  GtkPlotCanvas *canvas = GTK_PLOT_CANVAS(*object);
  GdkPixbuf *image;
  gboolean return_value;
  gint width, height;
  GdkBitmap *mask = NULL;
  GdkPixmap *pixmap = canvas->pixmap;
  GdkPixmap *new_pixmap = NULL;
  gdouble m = canvas->magnification; 

  canvas->pixmap = NULL;
  gtk_plot_canvas_set_magnification(canvas, 1.0);
  gtk_plot_canvas_paint(canvas);
  new_pixmap = canvas->pixmap;
  canvas->pixmap = pixmap;
  gtk_plot_canvas_set_magnification(canvas, m);

  gdk_window_get_size(new_pixmap, &width, &height);
  image = gdk_pixbuf_get_from_drawable(NULL, new_pixmap, gdk_drawable_get_colormap(new_pixmap), 0, 0, 0, 0, width, height); 

  if(image)
    return_value = gdk_pixbuf_save(image, (gchar *)filename, NULL, NULL, NULL);
  else
    return_value = FALSE;
 
  if(image) gdk_pixbuf_unref(image); 
  gdk_pixmap_unref(new_pixmap);

  return return_value;
}

