/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "pixmaps/sg_small.xpm"
#include <libxml/xmlreader.h>
#include "sg_types.h"

typedef struct
{
  SGdataset *dataset;
  gchar *last_node;
} parser_state;

static void	init_default		(SGpluginFile *plugin);
static gboolean xml_read_default   	(SGpluginFile *plugin, 
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data);
  

void
sg_dataset_file_xml_open_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  init_default(plugin);
}

gboolean
sg_dataset_file_xml_open		(SGpluginFile *plugin,
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data)
{
  return xml_read_default(plugin, filename, stream, object, data);
}

void
sg_dataset_worksheet_xml_open_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  init_default(plugin);
}

gboolean
sg_dataset_worksheet_xml_open		(SGpluginFile *plugin,
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data)
{
  return xml_read_default(plugin, filename, stream, object, data);
}


void
sg_dataset_matrix_xml_open_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean
sg_dataset_matrix_xml_open		(SGpluginFile *plugin,
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data)
{
  return xml_read_default(plugin, filename, stream, object, data);
}

void
sg_dataset_function_xml_open_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean
sg_dataset_function_xml_open		(SGpluginFile *plugin,
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data)
{
  return xml_read_default(plugin, filename, stream, object, data);
}

void
sg_dataset_python_xml_open_init(SGpluginFile *plugin)
{
  init_default(plugin);
}

gboolean
sg_dataset_python_xml_open		(SGpluginFile *plugin,
			     		 const gchar *filename, 
			     		 FILE *stream,
                             		 GObject **object, gpointer data)
{
  return xml_read_default(plugin, filename, stream, object, data);
}

static void 
init_default(SGpluginFile *plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".sg");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

static void
process_node(xmlTextReaderPtr reader, parser_state *state)
{
  xmlChar *name = xmlTextReaderName(reader);

  /* Start Element */

  if(xmlTextReaderNodeType(reader) == 1){
    SGworksheet *worksheet = NULL;

    if(strcmp(name,"sgp:Arg") == 0){
      guint type = 0;
      gchar *arg_value = NULL;
      gchar *arg_name = NULL;
      GtkArg arg[1];

      while(xmlTextReaderMoveToNextAttribute(reader)){
        xmlChar *child = xmlTextReaderName(reader);
        xmlChar *value = xmlTextReaderValue(reader);

        if(strcmp(child, "Type") == 0) type = _gtk_fundamental_type[atoi(value)];
        if(strcmp(child, "Value") == 0) arg_value = g_strdup(value);
        if(strcmp(child, "Name") == 0) arg_name = g_strdup(value);

        xmlFree(child);
        xmlFree(value);
      }

      arg[0].type = (GtkType)type;
      arg[0].name = arg_name;
      switch(type){
        case GTK_TYPE_UINT:
        case _GTK_TYPE_UINT:
          GTK_VALUE_UINT(arg[0]) = (guint)atoi(arg_value);
          g_object_set(G_OBJECT(state->dataset), arg_name, (guint)atoi(arg_value), NULL);
          break;
        case GTK_TYPE_ENUM:
        case _GTK_TYPE_ENUM:
          GTK_VALUE_ENUM(arg[0]) = (guint)atoi(arg_value);
          g_object_set(G_OBJECT(state->dataset), arg_name, (guint)atoi(arg_value), NULL);
          break;
        case GTK_TYPE_INT:
        case _GTK_TYPE_INT:
          GTK_VALUE_INT(arg[0]) = atoi(arg_value);
          g_object_set(G_OBJECT(state->dataset), arg_name, atoi(arg_value), NULL);
          break;
        case GTK_TYPE_DOUBLE:
        case _GTK_TYPE_DOUBLE:
          GTK_VALUE_DOUBLE(arg[0]) = atof(arg_value);
          g_object_set(G_OBJECT(state->dataset), arg_name, (gdouble)atof(arg_value), NULL);
          break;
        case GTK_TYPE_BOOL:
        case _GTK_TYPE_BOOL:
          GTK_VALUE_BOOL(arg[0]) = (gboolean)atoi(arg_value);
          g_object_set(G_OBJECT(state->dataset), arg_name, (gboolean)atoi(arg_value), NULL);
          break;
        case GTK_TYPE_STRING:
        case _GTK_TYPE_STRING:
          GTK_VALUE_STRING(arg[0]) = arg_value;
          g_object_set(G_OBJECT(state->dataset), arg_name, arg_value, NULL);
          break;
        case GTK_TYPE_POINTER:
        case _GTK_TYPE_POINTER:
// FIXME          worksheet = sg_get_worksheet(arg_value);
          GTK_VALUE_POINTER(arg[0]) = worksheet;
          g_object_set(G_OBJECT(state->dataset), arg_name, (gpointer)worksheet, NULL);
          break;
        default:
          break;
      }

      if(arg_name) g_free(arg_name);
      if(arg_value) g_free(arg_value);
    }

    if(state->last_node) g_free(state->last_node);
    state->last_node = g_strdup(name);
  }

  xmlFree(name);
}

static gboolean 
xml_read_default   		(SGpluginFile *plugin, 
			     	 const gchar *filename, 
			     	 FILE *stream,
                             	 GObject **object, gpointer data)
{  
  xmlTextReaderPtr reader;
  gint ret_val;
  parser_state *state;

  state = g_new0(parser_state, 1);
  state->last_node = NULL;

  if(data)
    reader = (xmlTextReaderPtr)data;
  else
    reader = xmlNewTextReaderFilename(filename);

  if(!reader) return FALSE;

  state->dataset = SG_DATASET(*object);
  ret_val = xmlTextReaderRead(reader);
  
  while(ret_val == 1){
    xmlChar *name = xmlTextReaderName(reader);

    process_node(reader, state);

    if(xmlTextReaderNodeType(reader) == 15 && strcmp(name, "sgp:Iterator") == 0){
      if(name) xmlFree(name);
      if(state->last_node) g_free(state->last_node);
/*
      sg_dataset_refresh(SG_DATASET(*object));
*/
      g_free(state);

      return TRUE;
    }

    xmlFree(name);
    ret_val = xmlTextReaderRead(reader);
  }
  if(!data) xmlFreeTextReader(reader);
  if(state->last_node) g_free(state->last_node);
  g_free(state);

  if(ret_val != 0) return FALSE;

  return TRUE;
}


