/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "pixmaps/sg_small.xpm"
#include "config.h"

static gboolean
default_read(const gchar *filename, GObject **object);
static gboolean
default_save(const gchar *filename, GObject **object);

void
image_jpeg_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".jpeg");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_jpeg_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_png_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".png");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_png_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_xpm_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".xpm");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_xpm_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_tiff_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".tiff");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_tiff_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_bmp_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".bmp");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_bmp_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_gif_open_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".gif");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
gboolean
image_gif_open        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_read(filename, object);
}

void
image_jpeg_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".jpeg");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_jpeg_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
image_png_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".png");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_png_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
image_xpm_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".xpm");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_xpm_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
image_tiff_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".tiff");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_tiff_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
image_bmp_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".bmp");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
image_bmp_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

void
image_gif_export_init(SGplugin *_plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".gif");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}
gboolean
image_gif_export        (SGpluginFile *plugin, 
			const gchar *filename, 
			FILE *stream,
                        GObject **object, gpointer data)
{  
  return default_save(filename, object);
}

static gboolean
default_read(const gchar *filename, GObject **object)
{
  GdkPixbuf *pixbuf = NULL;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;

  pixbuf = gdk_pixbuf_new_from_file((gchar *)filename, NULL);
  if(pixbuf){
    GtkPixmap *wpixmap = GTK_PIXMAP(*object);

    gdk_pixbuf_render_pixmap_and_mask(pixbuf, &pixmap, &mask, 0);
    gdk_pixbuf_unref(pixbuf);

    if(pixmap && mask){
      gtk_pixmap_set(wpixmap, pixmap, mask);
      gdk_pixmap_unref(pixmap);
      gdk_bitmap_unref(mask);
    } else {
      return FALSE;
    }
  } else {
    return FALSE;
  }

  return TRUE;
}

static gboolean
default_save(const gchar *filename, GObject **object)
{
  GdkPixbuf *image;
  gboolean return_value;
  gint width, height;

  gdk_window_get_size((GdkWindow *)GTK_PIXMAP(object)->pixmap, &width, &height);
  image = gdk_pixbuf_get_from_drawable(NULL, GTK_PIXMAP(object)->pixmap, gdk_drawable_get_colormap(GTK_PIXMAP(object)->pixmap), 0, 0, 0, 0, width, height);

  if(image)
    return_value = gdk_pixbuf_save(image, (gchar *)filename, NULL, NULL, NULL);
  else
    return_value = FALSE;
 
  if(image) gdk_pixbuf_unref(image); 

  return return_value;
}

