/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_style_file.h"
#include "sg_style_file_reader.h"
#include "pixmaps/sg_small.xpm"

static void 		xml_open_init			(SGpluginFile *plugin);
static gboolean 	xml_open_default 		(SGpluginFile *plugin, 
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data);

void
scatter_2d_xml_open_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  xml_open_init(plugin);
}

gboolean
scatter_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
scatter_3d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
scatter_3d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
scatter_polar_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
scatter_polar_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
hbars_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
hbars_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
vbars_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
vbars_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
hboxes_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
hboxes_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
vboxes_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
vboxes_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
bubbles_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
bubbles_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
bubbles_3d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
bubbles_3d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
bubbles_polar_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
bubbles_polar_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
color_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
color_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
color_3d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
color_3d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
color_polar_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
color_polar_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
contour_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
contour_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
contour_3d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
contour_3d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
lines_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
lines_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
lines_polar_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
lines_polar_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
lpoints_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
lpoints_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
lpoints_polar_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
lpoints_polar_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
density_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
density_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
surface_3d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
surface_3d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}

void
vectors_2d_xml_open_init(SGpluginFile *plugin)
{
  xml_open_init(plugin);
}

gboolean
vectors_2d_xml_open					(SGpluginFile *plugin,
                                    	 		 const gchar *filename,
			            	 		 FILE *opened,
                                   	 		 GObject **object, 
							 gpointer data)
{
  return xml_open_default(plugin, filename, opened, object, data);
}


static void 
xml_open_init(SGpluginFile *plugin)
{
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  plugin->mode = SG_PLUGIN_FILE_OPEN;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".sgd");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

static gboolean
xml_open_default	       (SGpluginFile *plugin, 
                        	const gchar *filename,
		        	FILE *opened,
                        	GObject **object, gpointer data)
{  
  xmlTextReaderPtr reader;


  if(data)
    reader = (xmlTextReaderPtr)data;
  else
    reader = xmlNewTextReaderFilename(filename);

  if(!reader) return FALSE;

  return sg_style_file_read_xml(reader, GTK_PLOT_DATA(*object));
}
