/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include <scigraphica/sg.h>
#include "sg_object_file_xml.h"
#include "pixmaps/sg_small.xpm"

void
sg_dataset_xml_export_init(SGplugin *_plugin)
{
  SGpluginFile *plugin = SG_PLUGIN_FILE(_plugin);
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  plugin->mode = SG_PLUGIN_FILE_EXPORT;
  plugin->nfilters = 1;
  sprintf(plugin->filter[0],".sgd");

  pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(), &mask, NULL, sg_small_xpm);
  plugin->pixmap = GTK_PIXMAP(gtk_pixmap_new(pixmap, mask));
  gdk_pixmap_unref(pixmap);
  gdk_bitmap_unref(mask);
}

gboolean
sg_dataset_xml_export (SGpluginFile *plugin, 
                       const gchar *filename,
		       FILE *opened,
                       GObject **object, gpointer _data)
{  
  FILE *file;
  SGdataset *dataset = NULL;
  GtkPlotData *real_data = NULL;
  SGpluginFile *iterator_plugin = NULL;
  SGpluginFile *style_plugin = NULL;
  SGpluginIterator *data_plugin = NULL;
  gchar *object_name = NULL;
  GObject *aux_object = NULL;

  if(GTK_IS_SG_DATASET(*object)){
    dataset = SG_DATASET(*object);
    real_data = GTK_PLOT_DATA(dataset->children->data);
  } else {
    real_data = GTK_PLOT_DATA(*object);
    dataset = SG_DATASET(real_data->link);
  }

  if(opened)
    file = opened;
  else
    file = sg_file_open(filename, "wb");
    
  if (!file){
       g_warning( _("ERROR: Cannot write to file: %s"), filename);
       return FALSE;
  } 

  if(!opened)  sg_file_printf(file,"<?xml version=\"1.0\"?>\n");

  sg_file_printf(file,"    <sgp:Dataset xmlns:sgp=\"http://scigraphica.sourceforge.net\">\n");
  sg_file_printf(file, "      <sgp:Doc Version=\"3.0\"/>\n");

  sg_file_printf(file, "      <sgp:Summary>\n");
  sg_file_printf(file, "        <sgp:Item>\n");
  sg_file_printf(file, "          <sgp:name>application</sgp:name>\n");
  sg_file_printf(file, "          <sgp:val-string>scigraphica</sgp:val-string>\n");
  sg_file_printf(file, "        </sgp:Item>\n");
  sg_file_printf(file, "        <sgp:Item>\n");
  sg_file_printf(file, "          <sgp:name>author</sgp:name>\n");
  sg_file_printf(file, "          <sgp:val-string>%s</sgp:val-string>\n", g_get_real_name());
  sg_file_printf(file, "        </sgp:Item>\n");
  sg_file_printf(file, "      </sgp:Summary>\n");

/*
  sg_object_file_export_xml(file, G_OBJECT(dataset), 3);
*/

  data_plugin = SG_PLUGIN_ITERATOR(dataset->plugin);

  sg_file_printf(file, "      <sgp:Iterator Name=\"%s\" Constructor=\"%s\">\n", SG_PLUGIN(data_plugin)->name, SG_PLUGIN(dataset->constructor)->name);

  iterator_plugin = sg_plugin_file_get("xml",SG_PLUGIN(data_plugin)->name,SG_PLUGIN_FILE_EXPORT);

  aux_object = G_OBJECT(dataset);
  if(iterator_plugin) 
    iterator_plugin->action(iterator_plugin, NULL, file, &aux_object, NULL);

  sg_file_printf(file, "      </sgp:Iterator>\n");

  style_plugin = sg_plugin_file_get("xml",SG_PLUGIN(dataset->constructor)->name,SG_PLUGIN_FILE_EXPORT);

  if(real_data){
    aux_object = G_OBJECT(real_data);
    style_plugin->action(style_plugin, NULL, file, &aux_object, NULL);
  }
  sg_file_printf(file,"    </sgp:Dataset>\n");


  if(!opened) sg_file_close(file);

  return TRUE;
}

